% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addCommentCode.R
\name{addCommentCode}
\alias{addCommentCode}
\title{Add Comments to R Code}
\usage{
addCommentCode(
  Model = "gpt-4o-mini",
  language = "English",
  SelectedCode = TRUE
)
}
\arguments{
\item{Model}{A character string specifying the GPT model to be used. Default is "gpt-4o-mini".}

\item{language}{A character string specifying the language for the comments. Default is "English".}

\item{SelectedCode}{A logical value indicating whether to use the selected code in RStudio. Default is TRUE.}
}
\value{
A message indicating completion if `SelectedCode` is TRUE, otherwise the commented code is copied to the clipboard.
}
\description{
This function adds comments to R code without modifying the input R code.
   It can either take the selected code from RStudio or read from the clipboard.
}
\details{
Add Comments to R Code
}
\examples{
\dontrun{
# Option 1
# Select some text in RStudio and then run the rstudio addins
# Option 2
# Copy the text into your clipboard then execute
addCommentCode(Model = "gpt-4o-mini", language = "English", SelectedCode = TRUE)
}
}
\author{
Satoshi Kume
}
