% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decorr.R
\name{bandwidth}
\alias{bandwidth}
\title{Bandwidth estimation}
\usage{
bandwidth(X, p1 = 0.3, p2 = 0.3, lag = 1)
}
\arguments{
\item{X}{numeric vector or matrix.}

\item{p1, p2}{exponents for sample size n resp. estimated dependency, between 0 and 1.}

\item{lag}{lag to which the autocorrelations are to be estimated. Integer > 0 but smaller than the length resp. number of rows and columns of X.}
}
\value{
A numeric vector containing one or two elements, depending on if a vector or matrix is supplied.
In case of a matrix: the first value is the bandwidth for the row-wise
and the second one for the column-wise estimation.
}
\description{
Calculate MSE-optimal bandwidths according to Andrews (1991).
}
\details{
Bandwidth \eqn{\boldsymbol{b}^{(n,m)} = (b_1^{(n)}, b_2^{(m)})} is estimated via
\deqn{b_i^{(k)} = \min\left(k-1, \max\left(1, k^{0.3} \left(\frac{2\rho_i}{1 - \rho_i^2}\right)^{0.3}\right)\right),}
where \eqn{\rho_1} and \eqn{\rho_2} are the mean row- resp. column-wise Spearman autocorrelations to lag 1.
}
\examples{
X1 <- genField(c(50, 50), Theta = genTheta(1, 0.4))
bandwidth(X1, 0.3, 0.3)

Theta <- matrix(c(0.08, 0.1, 0.08, 0.8, 1, 0.8, 0.08, 0.1, 0.08), ncol = 3)
X2 <- genField(c(50, 50), Theta = Theta)
bandwidth(X2, 1/3, 2/3)

}
\references{
Andrews, D. W. (1991). “Heteroskedasticity and autocorrelation consistent covariance
matrix estimation”. In: Econometrica: Journal of the Econometric Society, pp. 817–858.
}
