% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jolliffe.R
\name{jolliffe_test}
\alias{jolliffe_test}
\title{Jolliffe test for multiple comparisons}
\usage{
jolliffe_test(
  y,
  trt,
  alpha = 0.05,
  method = "single",
  show_plot = TRUE,
  console = TRUE,
  abline_options,
  ...
)
}
\arguments{
\item{y}{Either a model (created with \code{lm()} or \code{aov()}) or a numerical
vector with the values of the response variable for each unit.}

\item{trt}{If \code{y} is a model, a string with the name of the column containing
the treatments. If \code{y} is a vector, a vector of the same length as \code{y}
with the treatments for each unit.}

\item{alpha}{Numeric value corresponding to the
significance level of the test. The default value is 0.05.}

\item{method}{\code{string} indicating the clustering method to be used. For
single linkage (the default method) either \code{"single"} or \code{"slca"}.
For complete linkage, either \code{"complete"} or \code{"clca"}.}

\item{show_plot}{Logical value indicating whether the constructed dendrogram
should be plotted or not.}

\item{console}{Logical value indicating whether the results should be printed
on the console or not.}

\item{abline_options}{\code{list} with optional arguments for the line in the
dendrogram.}

\item{...}{Optional arguments for the \code{plot()} function.}
}
\value{
A list with three \code{data.frame} and one \code{hclust}:
\item{stats}{\code{data.frame} containing summary statistics by treatment.}
\item{groups}{\code{data.frame} indicating the group to which each treatment is
assigned.}
\item{parameters}{\code{data.frame} with the values used for the test.
\code{treatments} is the total number of treatments, \code{alpha} is the
significance level used, \code{n} is either the number of repetitions for all
treatments or the harmonic mean of said repetitions, \code{MSE} is the mean
standard error from the ANOVA table and \code{SEM} is an estimate of the
standard error of the mean.}
\item{dendrogram_data}{object of class \code{hclust} with data used to build
the dendrogram.}
}
\description{
I.T. Jolliffe test for multiple comparisons.
Implements a cluster-based alternative closely linked to the
Student-Newman-Keuls multiple comparison method. Single-linkage cluster
analysis is applied, using the p-values obtained with the SNK test for
pairwise mean comparison as a similarity measure. Groups whose means join
beyond \eqn{1 - \alpha} are statistically different. Alternatively, complete
linkage cluster analysis can also be applied.
}
\examples{
data("PlantGrowth")
# Using vectors -------------------------------------------------------
weights <- PlantGrowth$weight
treatments <- PlantGrowth$group
jolliffe_test(y = weights, trt = treatments, alpha = 0.1, show_plot = FALSE)
# Using a model -------------------------------------------------------
model <- lm(weights ~ treatments)
jolliffe_test(y = model, trt = "treatments", alpha = 0.1, show_plot = FALSE)
}
\references{
Jolliffe, I. T. (1975). Cluster analysis as a multiple comparison
method. \emph{Applied Statistics: Proceedings of Conference at Dalhousie
University, Halifax}, 159-168.
}
\author{
Santiago Garcia Sanchez
}
