% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plot_histogram}
\alias{plot_histogram}
\title{Create publication-quality histogram}
\usage{
plot_histogram(data, col, bins = 30, add_density = TRUE)
}
\arguments{
\item{data}{A data.frame containing survey data}

\item{col}{Character string specifying column name for numeric variable}

\item{bins}{Number of bins for histogram (default: 30)}

\item{add_density}{Logical whether to add density curve (default: TRUE)}
}
\value{
A ggplot object
}
\description{
This function creates a clean, publication-quality histogram for numeric variables
using ggplot2 with minimal theme and appropriate statistical overlays.
}
\examples{
data <- data.frame(age = rnorm(100, 35, 10))
hist_plot <- plot_histogram(data, "age")
print(hist_plot)
}
