% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ATCbyDrug.R
\name{ATCbyDrug}
\alias{ATCbyDrug}
\title{Fully Nested ATC2 → ATC4 → Drug (CMDECOD) Table by Treatment (wide)}
\usage{
ATCbyDrug(
  indata,
  dmdata,
  group_vars,
  trtan_coln,
  rtf_safe = TRUE,
  sort_by = c("count", "alpha"),
  atc4_spaces = NULL,
  cmdecod_spaces = NULL,
  atc4_rtf = "(*ESC*)R/RTF\\"\\\\li180 \\"",
  cmdecod_rtf = "(*ESC*)R/RTF\\"\\\\li360 \\""
)
}
\arguments{
\item{indata}{A data frame containing medication/event records. Must include:
\code{USUBJID} and the variables named in \code{group_vars}.}

\item{dmdata}{A data frame with one row per subject (for denominators). Must include
\code{USUBJID} and the main treatment grouping variable (first element of \code{group_vars}).}

\item{group_vars}{Character vector of length 4 specifying, in order:
\code{c(main_group, atc2, atc4, meddecod)}.
\itemize{
\item \code{main_group} = treatment/grouping variable used for columns (e.g., \code{"TRTAN"}).
\item \code{atc2}, \code{atc4}, \code{meddecod} = the three nested display levels.
}}

\item{trtan_coln}{Character scalar giving the \strong{column-level} of interest used
for count-based sorting, i.e., the suffix in \verb{n__<trtan_coln>}. Example: \code{"21"}
makes the function look for \code{n__21} to drive \code{"count"} sorting.}

\item{rtf_safe}{Logical; if \code{TRUE}, RTF strings will be used in \code{stat} \strong{when}
both \code{atc4_spaces} and \code{cmdecod_spaces} are \code{NULL}. If either spaces
argument is provided, \code{stat} will \strong{not} include RTF strings.}

\item{sort_by}{One of \code{c("count","alpha")}. See Details.}

\item{atc4_spaces, cmdecod_spaces}{\code{NULL} or non-negative integer specifying the
number of \strong{blank spaces} to prepend for \code{ATC4} and \code{Drug (CMDECOD)} labels in \code{stat}.
If either is non-\code{NULL}, the function uses \strong{SAS blanks mode} (no RTF codes).}

\item{atc4_rtf, cmdecod_rtf}{Character RTF indent strings used \strong{only} when
\emph{both} \code{atc4_spaces} and \code{cmdecod_spaces} are \code{NULL} and \code{rtf_safe = TRUE}.
Defaults: \verb{(*ESC*)R/RTF"\\\\li180 "} for \code{ATC4}, \verb{(*ESC*)R/RTF"\\\\li360 "} for \code{Drug (CMDECOD)}.}
}
\value{
A tibble with nested rows containing:
\itemize{
\item \code{stat} (indented label),
\item treatment columns \verb{trt*} (string \code{"n (pct)"}),
\item raw-count columns \verb{n__*},
\item helper ordering columns (\code{sec_ord}, \code{psec_ord}, \code{sort_ord}).
}
}
\description{
Builds a three-level nested summary table of concomitant medications (or similar data),
grouped as \strong{ATC2 → ATC4 → Drug (CMDECOD)}, with counts and percentages by treatment arm.
Outputs a \strong{wide} data frame where each treatment column contains \code{n (pct)}.

Two indent modes are supported for the display label column \code{stat}:
\itemize{
\item \strong{RTF mode (default):} If \code{atc4_spaces} and \code{cmdecod_spaces} are both \code{NULL},
and \code{rtf_safe = TRUE}, \code{stat} will include the provided RTF indent strings
(\code{atc4_rtf}, \code{cmdecod_rtf}) before the label text.
\item \strong{SAS blanks mode:} If \code{atc4_spaces} or \code{cmdecod_spaces} is provided (non-\code{NULL}),
\code{stat} will use \strong{only blank spaces} (no RTF codes) as visual indents (SAS-style),
regardless of \code{rtf_safe}.
}

Sorting can be controlled by \code{sort_by}:
\itemize{
\item \code{"count"} (default): within each level, sort descending by counts for the column
\verb{n__<trtan_coln>} (e.g., \code{n__21}), then alphabetically.
\item \code{"alpha"}: alphabetical ascending order at each level.
}

Rows where \strong{all three levels} are \code{"UNCODED"} (case-insensitive) are pushed to
the very end of the table (after all other rows), preserving the nested order.
}
\details{
\strong{Denominator (\code{N})} is computed from \code{dmdata} as distinct \code{USUBJID} per \code{main_group}.
For each level (ATC2, ATC4 within ATC2, Drug/CMDECOD within ATC4), the function computes
distinct-subject counts by \code{main_group}, the percentage w.r.t. \code{N}, and forms
\code{"n (pct)"}. The wide result has:
\itemize{
\item \code{stat} = display label with indent (RTF or blanks, depending on mode).
\item \verb{trt<value>} columns (e.g., \code{trt21}, \code{trt22}, …): \code{"n (pct)"} per treatment value.
\item \verb{n__<value>} columns mirroring raw counts (useful for custom sorting or QC).
\item Ordering columns: \code{sec_ord}, \code{psec_ord}, \code{sort_ord} (help keep nested order).
}

\strong{Indent modes}:
\itemize{
\item \emph{RTF mode}: Use when you want RTF control words in the output for direct
RTF rendering. Do \strong{not} set \code{atc4_spaces}/\code{cmdecod_spaces}; keep \code{rtf_safe = TRUE}.
\item \emph{SAS blanks mode}: Provide \code{atc4_spaces} and/or \code{cmdecod_spaces} to indent using
blanks only (friendly for plain-text outputs or RTF pipelines that inject
formatting later).
}

\strong{UNCODED handling}:
Rows are considered UNCODED \strong{only if} all three of \code{ATC2}, \code{ATC4}, and \code{Drug (CMDECOD)}
equal \code{"UNCODED"} (case-insensitive, leading/trailing space ignored). Such rows are
assigned to the end of the table after sorting.
}
\examples{

library(dplyr)

cm <- tibble::tribble(
  ~USUBJID, ~TRTAN, ~ATC2,      ~ATC4,         ~CMDECOD,
  "01",       21,   "A - Alim.", "A01A",        "CHLORHEXIDINE",
  "01",       21,   "A - Alim.", "A01A",        "CHLORHEXIDINE",
  "02",       21,   "A - Alim.", "A01A",        "NYSTATIN",
  "03",       22,   "A - Alim.", "A01A",        "NYSTATIN",
  "04",       22,   "J - Anti.", "J01C",        "AMOXICILLIN",
  "05",       21,   "J - Anti.", "J01C",        "AMOXICILLIN",
  "06",       22,   "UNCODED",   "UNCODED",     "UNCODED"
)



dm <- tibble::tribble(
  ~USUBJID, ~TRTAN,
  "01",       21,
  "02",       21,
  "05",       21,
  "03",       22,
  "04",       22,
  "06",       22
)

out_rtf <- ATCbyDrug(
  indata      = cm,
  dmdata      = dm,
  group_vars  = c("TRTAN", "ATC2", "ATC4", "CMDECOD"),
  trtan_coln  = "21",
  rtf_safe    = TRUE,
  sort_by     = "count"
)

out_rtf



out_spaces <- ATCbyDrug(
  indata          = cm,
  dmdata          = dm,
  group_vars      = c("TRTAN", "ATC2", "ATC4", "CMDECOD"),
  trtan_coln      = "21",
  sort_by         = "count",
  atc4_spaces     = 2,
  cmdecod_spaces  = 4
)

out_spaces



out_alpha <- ATCbyDrug(
  indata      = cm,
  dmdata      = dm,
  group_vars  = c("TRTAN", "ATC2", "ATC4", "CMDECOD"),
  trtan_coln  = "21",
  sort_by     = "alpha",
  rtf_safe    = FALSE
)

out_alpha


}
