% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.Silhouette.R
\name{is.Silhouette}
\alias{is.Silhouette}
\title{Check if Object is of Class Silhouette}
\usage{
is.Silhouette(x, strict = FALSE)
}
\arguments{
\item{x}{An object to test}

\item{strict}{Logical; if TRUE, performs additional structural validation
beyond just class checking (default: FALSE)}
}
\value{
Logical; TRUE if the object is of class "Silhouette", FALSE otherwise
}
\description{
Tests whether an object is of class "Silhouette". This function checks both
the class inheritance and the expected structure of a Silhouette object.
}
\details{
When \code{strict = FALSE}, the function only checks if the object inherits
from the "Silhouette" class.

When \code{strict = TRUE}, the function additionally validates:
\itemize{
\item Object is a data frame
\item Has required columns: cluster, neighbor, sil_width
\item Has required attributes: proximity_type, method, average
\item Column types are appropriate (integer for cluster/neighbor, numeric for sil_width)
}

The Silhouette object attributes are validated as follows:
\itemize{
\item \code{proximity_type}: Must be one of "dissimilarity" or "similarity"
\item \code{average}: Must be one of "crisp", "fuzzy", or "median"
\item \code{method}: Can be NULL or any string
}
}
\examples{
# Create a Silhouette object
cluster_assignments <- c(1, 1, 2, 2, 3, 3)
neighbor_clusters <- c(2, 2, 1, 1, 1, 1)
silhouette_widths <- c(0.8, 0.7, 0.6, 0.9, 0.5, 0.4)

sil_obj <- getSilhouette(
  cluster = cluster_assignments,
  neighbor = neighbor_clusters,
  sil_width = silhouette_widths,
  proximity_type = "dissimilarity",
  method = "medoid",
  average = "crisp"
)

# Test if object is Silhouette
is.Silhouette(sil_obj)          # TRUE
is.Silhouette(sil_obj, strict = TRUE)  # TRUE

# Test with non-Silhouette objects
is.Silhouette(data.frame(a = 1, b = 2))  # FALSE
is.Silhouette(matrix(1:10, ncol = 2))    # FALSE
is.Silhouette(list(a = 1, b = 2))        # FALSE
is.Silhouette(NULL)                       # FALSE

}
\seealso{
\code{\link{Silhouette}}, \code{\link{softSilhouette}}, \code{\link{dbSilhouette}}, \code{\link{cerSilhouette}}, \code{\link{getSilhouette}}, \code{\link{plotSilhouette}}
}
