% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Random_shif.R
\name{random.shift}
\alias{random.shift}
\title{Apply a circular random shift to the temporal component of a spatio-temporal point pattern}
\usage{
random.shift(X, shifted_col = 3)
}
\arguments{
\item{X}{A numeric matrix or data frame containing the spatio-temporal point pattern.
Must include at least one numeric column representing time.}

\item{shifted_col}{Integer index specifying which column to shift (typically the
time coordinate). Default is \code{3}.}
}
\value{
A matrix or data frame (matching the input type) with the time column shifted modulo 1.
}
\description{
Performs a circular random shift of the temporal coordinate in a spatio-temporal
point pattern. This operation preserves the spatial configuration while
randomizing the temporal component under the assumption of temporal stationarity.
The shift amount is drawn uniformly from \eqn{[0, 1]} and applied modulo 1, ensuring
that the time window is maintained. The resulting dataset can be used to construct
null models for hypothesis testing of first-order separability or temporal independence.
}
\details{
The circular random shift is a common resampling procedure for generating
null models of temporal randomness while preserving the overall temporal
marginal distribution and spatial structure.

For each dataset, a single uniform random shift value
\eqn{\Delta \sim \mathrm{Uniform}(0,1)} is drawn and added to the temporal
coordinate. The shifted times are then wrapped around the unit interval:

\deqn{
t_i^{*} = (t_i + \Delta) \bmod 1, \quad i = 1, \dots, n.
}
}
\examples{

set.seed(123)
X <- cbind(runif(100), runif(100), runif(100))  # x, y, t
X_shifted <- random.shift(X)

# Compare original and shifted time values
head(X[,3])
head(X_shifted[,3])

# Verify shift visually
plot(X[, 3], type = "o", col = "blue", ylab = "Time", xlab = "Index",
     main = "Original vs Shifted Times")
lines(X_shifted[, 3], type = "o", col = "red")
legend("topright", legend = c("Original", "Shifted"),
       col = c("blue", "red"), lty = 1, pch = 1)

}
\references{
Ghorbani, M., Vafaei, N., Dvořák, J., and Myllymäki, M. (2021).
Testing the first-order separability hypothesis for spatio-temporal point patterns.
\emph{Computational Statistics & Data Analysis}, 161, 107245.
}
