% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_args.R
\name{check.args}
\alias{check.args}
\title{Validate common arguments for spatio-temporal grid-based routines}
\usage{
check.args(X, s.region, t.region, n.grid = c(25L, 25L, 20L))
}
\arguments{
\item{X}{A matrix or data frame with at least three columns giving event coordinates
\eqn{(x, y, t)}. Only the first three columns are used for validation.}

\item{s.region}{Spatial observation region specification. Either:
\itemize{
\item a numeric vector of length 4 giving \code{c(xmin, xmax, ymin, ymax)}, or
\item a numeric matrix with two columns giving polygon vertices \code{(x, y)} (at least 3 rows).
}
All values must be finite.}

\item{t.region}{Numeric vector of length 2 giving \code{c(tmin, tmax)} with \code{tmin < tmax}.
Values must be finite.}

\item{n.grid}{Integer vector of length 3 giving the number of grid cells in the \eqn{x}, \eqn{y},
and time directions. Must be positive.}
}
\value{
Invisibly returns \code{NULL}. Called for its side effect of throwing an error if inputs are invalid.
}
\description{
Checks the validity of common inputs used by spatio-temporal estimation and simulation
routines: event locations \code{X}, spatial window specification \code{s.region}, temporal window
\code{t.region}, and grid resolution \code{n.grid}.
}
\details{
This function is intended as a lightweight argument checker used internally by multiple functions.
It can also be called directly for debugging input issues.
}
\examples{

X <- cbind(runif(100), runif(100), runif(100, 0, 10))
s.region <- matrix(c(0,0, 1,0, 1,1, 0,1), ncol = 2, byrow = TRUE)
t.region <- c(0, 10)
check.args(X, s.region, t.region, n.grid = c(25, 25, 20))

}
