% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flag_fossil.R
\name{flag_fossil}
\alias{flag_fossil}
\title{Flag fossil records}
\usage{
flag_fossil(
  occ,
  columns = c("basisOfRecord", "occurrenceRemarks"),
  fossil_terms = NULL
)
}
\arguments{
\item{occ}{(data.frame) a data frame containing the occurrence records to be
examined, preferably standardized using \code{format_columns()}. Must contain the
columns specified in \code{columns}.}

\item{columns}{(character) vector of column names in \code{occ} where the function
will search for the term \code{"fossil"} or other fossil-related expressions.
Default is \code{c("basisOfRecord", "occurrenceRemarks")}.}

\item{fossil_terms}{(character) optional vector of additional terms that
indicate a fossil record (e.g., \code{"paleontological"}, \code{"subfossil"}). Default
is \code{NULL}.}
}
\value{
A \code{data.frame} that is the original \code{occ} data frame augmented with
a new column named \code{fossil_flag}. Records identified as fossils receive
\code{FALSE}, while all other records receive \code{TRUE}.
}
\description{
This function identifies occurrence records that correspond to fossils,
based on specific search terms found in selected columns.
}
\examples{
# Load example data
data("occurrences", package = "RuHere")
# Flag fossil records
occ_fossil <- flag_fossil(occ = occurrences)
}
