% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichment.R
\name{KO_gsa}
\alias{KO_gsa}
\title{Perform gene set analysis}
\usage{
KO_gsa(
  reporter_res,
  method = "Two class unpaired",
  p.adjust.method = "BH",
  verbose = TRUE,
  perm = 1000,
  ...
)
}
\arguments{
\item{reporter_res}{reporter_res}

\item{method}{Problem type: "quantitative" for a continuous parameter; "Two class unpaired" ; "Survival" for censored survival outcome; "Multiclass" : more than 2 groups, coded 1,2,3...; "Two class paired" for paired outcomes, coded -1,1 (first pair), -2,2 (second pair), etc}

\item{p.adjust.method}{"BH"}

\item{verbose}{TRUE}

\item{perm}{1000}

\item{...}{additional parameters to \code{\link[GSA]{GSA}}}
}
\value{
enrich_res object
}
\description{
Perform gene set analysis
}
\examples{
\donttest{
## use `GSA` from the `GSA` package.
if (requireNamespace("GSA")) {
  data("reporter_score_res")
  gsa_res <- KO_gsa(reporter_score_res, p.adjust.method = "none", perm = 200)
  plot(gsa_res)
}
}
}
\seealso{
Other common_enrich: 
\code{\link{KO_enrich}()},
\code{\link{KO_fisher}()},
\code{\link{KO_gsea}()},
\code{\link{KO_gsva}()},
\code{\link{KO_padog}()},
\code{\link{KO_safe}()},
\code{\link{KO_sea}()},
\code{\link{plot_enrich_res}()}
}
\concept{common_enrich}
