% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_deeplearning.R
\name{tcn_detect}
\alias{tcn_detect}
\title{TCN-based Changepoint Detection}
\usage{
tcn_detect(
  data,
  true_changepoints = NULL,
  window_size = 64,
  n_filters = 64,
  kernel_size = 3,
  dilations = c(1, 2, 4, 8, 16),
  dropout = 0.2,
  epochs = 50,
  threshold = 0.5,
  verbose = FALSE
)
}
\arguments{
\item{data}{Numeric vector of time series data}

\item{true_changepoints}{Optional vector of known changepoints for
supervised training. If NULL, uses unsupervised approach.}

\item{window_size}{Size of input window (default: 64)}

\item{n_filters}{Number of convolutional filters (default: 64)}

\item{kernel_size}{Kernel size for convolutions (default: 3)}

\item{dilations}{Dilation rates (default: c(1, 2, 4, 8, 16))}

\item{dropout}{Dropout rate (default: 0.2)}

\item{epochs}{Training epochs (default: 50)}

\item{threshold}{Detection threshold (default: 0.5)}

\item{verbose}{Show training progress (default: FALSE)}
}
\value{
List with changepoints, probabilities, and model
}
\description{
Uses Temporal Convolutional Networks with dilated causal convolutions
for sequence-to-sequence changepoint prediction.
}
\references{
Bai, S., Kolter, J. Z., and Koltun, V. (2018). An Empirical Evaluation
of Generic Convolutional and Recurrent Networks for Sequence Modeling
}
