% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rwtbl_helpers.R
\name{rwtbl_get_scen_folder}
\alias{rwtbl_get_scen_folder}
\title{Map a scenario name to the original scenario folder}
\usage{
rwtbl_get_scen_folder(rwtblsmmry, scenarios)
}
\arguments{
\item{rwtblsmmry}{A tbl_df of summarized RiverWare data; likely output from
\code{\link[=rw_scen_aggregate]{rw_scen_aggregate()}}.}

\item{scenarios}{A vector of scenario names to map to scenario folders.}
}
\value{
A vector of scenario folders; \code{character(0)} if none of the
\code{scenarios} are found.
}
\description{
\code{rwtbl_get_scen_folder()} provides the original file path to the scenario
folder for the specified scenario name(s) (\code{scenarios}). If \code{scenarios} are
not found in \code{rwtblsmmry}, a warning message is posted.
}
\examples{
rwtbl_get_scen_folder(scen_data, "Most")
rwtbl_get_scen_folder(scen_data, c("Most", "2002"))

}
