% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prevalence_functions.R
\name{n.ap}
\alias{n.ap}
\title{Sample size for apparent prevalence}
\usage{
n.ap(p, precision, conf = 0.95)
}
\arguments{
\item{p}{expected proportion, scalar or vector of values}

\item{precision}{absolute precision, +/- proportion equivalent to
half the width of the desired confidence interval, scalar or vector of values,
note: at least one of p and precision must be a scalar}

\item{conf}{level of confidence required, default = 0.95 (scalar)}
}
\value{
a vector of sample sizes
}
\description{
Calculates sample size for estimating apparent 
prevalence (simple proportion)
}
\examples{
# examples of n.ap
n.ap(0.5, 0.1)
n.ap(0.5, 0.1, conf=0.99)
n.ap(seq(0.1, 0.5, by = 0.1), 0.05)
n.ap(0.2, c(0.01, 0.02, 0.05, 0.1))
}
\keyword{methods}
