
SnnsDefines <- list()

SnnsDefines$errorCodes <- 
    matrix(c(
            "KRERR_NO_ERROR",         0,
            "KRERR_INSUFFICIENT_MEM", -1,
            "KRERR_UNIT_NO",          -2,
            "KRERR_OUTFUNC",          -3,
            "KRERR_ACTFUNC",          -4,
            "KRERR_SITEFUNC",         -5,
            "KRERR_CREATE_SITE",      -6,
            "KRERR_ALREADY_CONNECTED",  -7,
            "KRERR_CRITICAL_MALLOC",  -8,
            "KRERR_FTYPE_NAME",       -9,
            "KRERR_FTYPE_ENTRY",      -10,
            "KRERR_COPYMODE",         -11,
            "KRERR_NO_SITES",         -12,
            "KRERR_FROZEN",           -13,
            "KRERR_REDEF_SITE_NAME",  -14,
            "KRERR_UNDEF_SITE_NAME",  -15,
            "KRERR_NOT_3D",           -16,
            "KRERR_DUPLICATED_SITE",  -17,
            "KRERR_INUSE_SITE",       -18,
            "KRERR_FTYPE_SITE",       -19,
            "KRERR_FTYPE_SYMBOL",     -20,
            "KRERR_IO",               -21,
            "KRERR_SAVE_LINE_LEN",    -22,
            "KRERR_FEW_LAYERS",       -23,
            "KRERR_NO_UNITS",         -24,
            "KRERR_EOF",              -25,
            "KRERR_LINE_LENGTH",      -26,
            "KRERR_FILE_FORMAT",      -27,
            "KRERR_FILE_OPEN",        -28,
            "KRERR_FILE_SYNTAX",      -29,
            "KRERR_MALLOC1",          -30,
            "KRERR_TTYPE",            -31,
            "KRERR_SYMBOL",           -32,
            "KRERR_NO_SUCH_SITE",     -33,
            "KRERR_NO_HIDDEN_UNITS",  -34,
            "KRERR_CYCLES",           -35,
            "KRERR_DEAD_UNITS",       -36,
            "KRERR_INPUT_PATTERNS",   -37,
            "KRERR_OUTPUT_PATTERNS",  -38,
            "KRERR_CHANGED_I_UNITS",  -39,
            "KRERR_CHANGED_O_UNITS",  -40,
            "KRERR_NO_INPUT_UNITS",   -41,
            "KRERR_NO_OUTPUT_UNITS",  -42,
            "KRERR_NO_PATTERNS",      -43,
            "KRERR_INCORE_PATTERNS",  -44,
            "KRERR_PATTERN_NO",       -45,
            "KRERR_LEARNING_FUNC",    -46,
            "KRERR_PARAMETERS",       -47,
            "KRERR_UPDATE_FUNC",      -48,
            "KRERR_INIT_FUNC",        -49,
            "KRERR_DERIV_FUNC",       -50,
            "KRERR_I_UNITS_CONNECT",  -51,
            "KRERR_O_UNITS_CONNECT",  -52,
            "KRERR_TOPOMODE",         -53,
            "KRERR_LEARNING_SITES",   -54,
            "KRERR_SITES_NO_SUPPORT", -55,
            "KRERR_NO_MASPAR_KERNEL", -56,
            "KRERR_NOT_NEIGHBOUR_LAYER", -57,
            "KRERR_MUCH_LAYERS",      -58,
            "KRERR_NOT_FULLY_CONNECTED", -59,
            "KRERR_MODE_FF1_INVALID_OP", -60,
            "KRERR_NET_TRANSFORM",    -61,
            "KRERR_NO_CURRENT_LINK",  -62,
            "KRERR_NO_CURRENT_UNIT",  -63,
            "KRERR_UNIT_NO_INPUTS",   -64,
            "KRERR_TOPO_DEFINITION",  -65,
            "KRERR_BAD_CONNECTION",   -66,
            "KRERR_MASPAR_NO_RESPOND", -67,
            "KRERR_NOT_IMPEMENTED_YET", -68,
            "KRERR_NOT_PARALLEL_MODE",  -69,
            "KRERR_MASPAR_OUT_OF_PE_MEM", -70,
            "KRERR_MASPAR_COMMUNICATE", -71,
            "KRERR_MASPAR_OUT_OF_PE",   -72,
            "KRERR_MISSING_DEFAULT_FUNC",  -73,
            "KRERR_MASPAR_MULTI_OUT_FUNC", -74,
            "KRERR_MASPAR_MULTI_ACT_FUNC", -75,
            "KRERR_NET_DEPTH",        -76,
            "KRERR_NO_OF_UNITS_IN_LAYER",         -77,
            "KRERR_UNIT_MISSING",                 -78,
            "KRERR_UNDETERMINED_UNIT",            -79,
            "KRERR_ACT_FUNC",                     -80,
            "KRERR_OUT_FUNC",                     -81,
            "KRERR_SITE_FUNC",                    -82,
            "KRERR_UNEXPECTED_SITES",             -83,
            "KRERR_UNEXPECTED_DIRECT_INPUTS",     -84,
            "KRERR_SITE_MISSING",                 -85,
            "KRERR_UNEXPECTED_LINK",              -86,
            "KRERR_LINK_MISSING",                 -87,
            "KRERR_LINK_TO_WRONG_SITE",           -88,
            "KRERR_TOPOLOGY",                     -89,
            "KRERR_PARAM_BETA",                   -90,
            "KRERR_CC_ERROR1",                    -91,
            "KRERR_CC_ERROR2",                    -92,
            "KRERR_CC_ERROR3",                    -93,
            "KRERR_CC_ERROR4",                    -94,
            "KRERR_CC_ERROR5",                    -95,
            "KRERR_CC_ERROR6",                    -96,
            "KRERR_CC_ERROR7",                    -97,
            "KRERR_CC_ERROR8",                    -98,
            "KRERR_CC_ERROR9",                    -99,
            "KRERR_CC_ERROR10",                  -100,
            "KRERR_CC_ERROR11",                  -101,
            "DLVQ_ERROR1",                       -102,
            "DLVQ_ERROR2",                       -103,
            "DLVQ_ERROR3",                       -104,
            "DLVQ_ERROR4",                       -105,
            "DLVQ_ERROR5",                       -106,
            "KRERR_NP_NO_MORE_ENTRIES",          -107,
            "KRERR_NP_NO_SUCH_PATTERN_SET",      -108,
            "KRERR_NP_NO_CURRENT_PATTERN",       -109,
            "KRERR_NP_DIMENSION",                -110,
            "KRERR_NP_NO_SUCH_PATTERN",          -111,
            "KRERR_NP_NO_CURRENT_PATTERN_SET",   -112,
            "KRERR_NP_DOES_NOT_FIT",             -113,
            "KRERR_NP_NO_TRAIN_SCHEME",          -114,
            "KRERR_NP_NO_OUTPUT_PATTERN",        -115,
            "KRERR_NP_INCOMPATIBLE_NEW",         -116,
            "KRERR_IP_ISNOTINITED",              -117,
            "KRERR_IP_ISINITED",                 -118,
            "KRERR_IP_SENDMSGFAILED",            -119,
            "KRERR_IP_MSGSYNTAX",                -120,
            "KRERR_IP_UNKNOWENCMD",              -121,
            "KRERR_IP_LESSPAT",                  -122,
            "KRERR_IP_WEIGHTUPDATE",             -123,
            "KRERR_IP_LEARNFNOTPAR",             -124,
            "KRERR_NP_WORKAROUND",               -130,
            "DDA_PARAM_ONE",                     -131,
            "DDA_PARAM_TWO",                     -132,
            "DDA_PARAM_THREE",                   -133,
            "DDA_DESIRED_CLASS",                 -134,
            "DDA_CONN_POINTER",                  -135,
            "DDA_SHORTCUTS",                     -136,
            "DDA_INPUT_ACT_FUNC",                -137,
            "DDA_HIDDEN_ACT_FUNC",               -138,
            "DDA_OUTPUT_ACT_FUNC",               -139,
            "KRERR_CC_INVALID_ADD_PARAMETERS",   -140,
            "KRERR_UPS_ACT_NOT_THRESHOLD",       -141,
            "KRERR_UPS_LEARN_NOT_BACKPROP",      -142,
            "KRERR_SINGLE_CLASS",                -143,
            "KRERR_REMAP_FUNC",                  -144,
            "KRERR_NO_CLASSES",                  -145,
            "KRERR_ILL_CLASS_DISTRIB",           -146,
            "KRERR_CANT_NORM",                   -147
        ),ncol=2,byrow=TRUE)


        
SnnsDefines$functionTypes <-  matrix(c(
"OUT_FUNC",        1,
"ACT_FUNC",        2,
"SITE_FUNC",       3,
"LEARN_FUNC",      4,
"UPDATE_FUNC",     5,
"INIT_FUNC",       6,
"ACT_DERIV_FUNC",  7,
"JOG_WEIGHT_FUNC", 8,
"ACT_2_DERIV_FUNC", 9,
"PRUNING_FUNC",    10,
"TEST_FUNC",       11,
"REMAP_FUNC",       12,
"FUNC_TYPE_MASK",  255,
"DEFAULT_FUNC",    256,
"BENCH_FUNC",      512,
"FF_LEARN_FUNC",   1024)          # used by pruning algorithms
        ,ncol=2,byrow=TRUE)
            
            
SnnsDefines$entryTypesNameTable <-  matrix(c(
"UNUSED_SYM",         0,
"UNIT_SYM",           1,
"SITE_SYM",           2,
"FTYPE_UNIT_SYM",     3)
                ,ncol=2,byrow=TRUE)
                
SnnsDefines$constantsNetworkAnalyzer <-  matrix(c(     
"MAX_ARRAY_SIZE", 5000,
"NA_ERROR_LIN",      1,
"NA_ERROR_SQR",      2,
"NA_ERROR_SU",       3)
                ,ncol=2,byrow=TRUE)            

SnnsDefines$copyModes <-  matrix(c("INPUTS_AND_OUTPUTS",     1,
"ONLY_INPUTS",            2,
"ONLY_OUTPUTS",           3,
"ONLY_UNIT",              4)
,ncol=2,byrow=TRUE)

SnnsDefines$topologicalUnitTypes <-
    matrix(c("UNIT_UNKNOWN",    0,
            "UNIT_INPUT",      1,
            "UNIT_OUTPUT",     2,
            "UNIT_HIDDEN",     3,
            "UNIT_DUAL",       4,
            "UNIT_SPECIAL",    5,
            "UNIT_SPECIAL_I",  6,
            "UNIT_SPECIAL_O",  7,
            "UNIT_SPECIAL_H",  8,
            "UNIT_SPECIAL_D",     9,
            "UNIT_SPECIAL_X",    10, # Only used for toggle special flag
            "UNIT_N_SPECIAL_X",  11) # Only used for toggle special flag
        ,ncol=2,byrow=TRUE)
            
SnnsDefines$unitInputTypes <-  matrix(c(
"NO_INPUTS",      0,
"SITES",          1,
"DIRECT_LINKS",   2)
        ,ncol=2,byrow=TRUE)

SnnsDefines$patternUpdateModes <-  matrix(c(
"OUTPUT_NOTHING",  1,
"OUTPUT_ACT",      2,
"OUTPUT_OUT",     3)      
                ,ncol=2,byrow=TRUE)
            
            