% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redcap_data.R
\name{redcap_data}
\alias{redcap_data}
\title{Read REDCap data}
\usage{
redcap_data(
  data_path = NA,
  dic_path = NA,
  event_path = NA,
  uri = NA,
  token = NA,
  sep = ",",
  filter_field = NULL,
  survey_fields = FALSE
)
}
\arguments{
\item{data_path}{Path to exported R file (use with \code{dic_path}).}

\item{dic_path}{Path to the dictionary file (CSV or XLSX; use with \code{data_path})..}

\item{event_path}{Path to the event-form mapping file (CSV or XLSX) for longitudinal projects (downloadable via the \verb{Designate Instruments for My Events} tab within the \verb{Project Setup} section of REDCap).}

\item{uri}{REDCap API base URI (use with \code{token}).}

\item{token}{REDCap API token (use with \code{uri}).}

\item{sep}{Character string specifying the field separator for the exported dictionary CSV file. Defaul \code{","}.}

\item{filter_field}{Optional character vector of field names to request from the API.}

\item{survey_fields}{Logical; include survey-related fields when pulling via API. Default \code{FALSE}.}
}
\value{
A list with:
\itemize{
\item \code{data}: Imported dataset.
\item \code{dictionary}: Variable dictionary (project metadata).
\item \code{event_form}: Event-form mapping for longitudinal projects (if applicable).
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Import REDCap data into R either from REDCap's exported R file or directly via the REDCap API. The function returns a list with the dataset, the project dictionary (metadata) and, for longitudinal projects, the instrument–event mapping (\code{event_form}) when available.
}
\details{
Two import modes are supported:
\itemize{
\item \strong{Exported files} — use \code{data_path} (REDCap R export) and \code{dic_path} (dictionary CSV/XLSX).
\item \strong{API} — use \code{uri} and \code{token} to pull data and metadata directly from REDCap.
}

If the project is longitudinal, provide \code{event_path} (instrument–event mapping)
or the function will attempt to fetch it from the API when using API mode.

\strong{Steps for using exported data in REDCap:}
\enumerate{
\item Use the REDCap \emph{Export Data} function and choose \emph{R Statistical Software} format.
\item REDCap generates:
\itemize{
\item A CSV file with observations.
\item An R script to format variables for import.
}
\item Ensure the exported files, dictionary, and event mapping (if any) are in the same directory.
}
}
\note{
To use other package functions effectively, include the \code{dic_path} argument to load the project dictionary.

\itemize{
\item Use either exported-files mode (\code{data_path} + \code{dic_path}) \strong{or} API mode (\code{uri} + \code{token}) — not both.
\item For exported files, REDCap's R export is required for \code{data_path}. Dictionary and event files must be CSV or XLSX.
}
}
\examples{
\dontrun{
# From exported files
out <- redcap_data(
  data_path = "project_export.r",
  dic_path  = "project_dictionary.csv",
  event_path = "instrument_event_map.csv"
)

# From API
out_api <- redcap_data(
  uri   = "https://redcap.example.org/api/",
  token = "REPLACE_WITH_TOKEN"
)
}

}
