% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_qq_heatmap}
\alias{plot_qq_heatmap}
\title{Heatmap for QQ Regression}
\usage{
plot_qq_heatmap(
  qq_result,
  type = c("coefficient", "rsquared", "pvalue"),
  colorscale = NULL,
  x_label = "X Variable Quantiles",
  y_label = "Y Variable Quantiles",
  title = NULL,
  zmin = NULL,
  zmax = NULL
)
}
\arguments{
\item{qq_result}{An object of class "qq_regression" or a data frame
with columns: y_quantile, x_quantile, coefficient, r_squared, p_value.}

\item{type}{Character string. Type of values to plot: "coefficient"
(default), "rsquared", or "pvalue".}

\item{colorscale}{Character string. Color scale to use. Options are:
\itemize{
  \item "Viridis" - Viridis scale (default for coefficient)
  \item "Plasma" - Plasma scale (default for rsquared)
  \item "Jet" - MATLAB-style rainbow (default for pvalue)
  \item "BlueRed" - Blue to red diverging scale
}}

\item{x_label}{Character string. Label for x-axis. Default is
"X Variable Quantiles".}

\item{y_label}{Character string. Label for y-axis. Default is
"Y Variable Quantiles".}

\item{title}{Character string. Plot title. If \code{NULL}, an
automatic title is generated.}

\item{zmin}{Numeric. Minimum value for color scale. If \code{NULL},
automatically determined.}

\item{zmax}{Numeric. Maximum value for color scale. If \code{NULL},
automatically determined.}
}
\value{
A plotly object representing the heatmap.
}
\description{
Creates an interactive heatmap of QQ regression results using plotly.
}
\examples{
# Generate example data
set.seed(42)
n <- 200
x <- rnorm(n)
y <- 0.5 * x + rnorm(n, sd = 0.5)

# Run QQ regression
result <- qq_regression(y, x, verbose = FALSE)

\donttest{
# Create coefficient heatmap
plot_qq_heatmap(result, type = "coefficient")

# Create R-squared heatmap
plot_qq_heatmap(result, type = "rsquared", colorscale = "Plasma")

# Create p-value heatmap
plot_qq_heatmap(result, type = "pvalue", colorscale = "Jet")
}

}
