% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance_analytics.R
\name{analyze_performance}
\alias{analyze_performance}
\title{Analyze Backtest Performance with Daily Monitoring}
\usage{
analyze_performance(
  backtest_result,
  daily_prices,
  benchmark_symbol = "SPY",
  rf_rate = 0,
  confidence_level = 0.95
)
}
\arguments{
\item{backtest_result}{Result object from run_backtest()}

\item{daily_prices}{Daily price data including all portfolio symbols}

\item{benchmark_symbol}{Symbol for benchmark comparison (default: "SPY")}

\item{rf_rate}{Annual risk-free rate for Sharpe/Sortino (default: 0)}

\item{confidence_level}{Confidence level for VaR/CVaR (default: 0.95)}
}
\value{
performance_analysis object with metrics and daily tracking
}
\description{
Calculates comprehensive performance metrics using daily price data for
enhanced accuracy. Provides risk-adjusted returns, drawdown analysis,
and benchmark comparison even when strategy trades at lower frequency.
}
\examples{
data("sample_prices_weekly")
data("sample_prices_daily")

# Use overlapping symbols; cap to 3
syms_all <- intersect(names(sample_prices_weekly)[-1], names(sample_prices_daily)[-1])
stopifnot(length(syms_all) >= 1)
syms <- syms_all[seq_len(min(3L, length(syms_all)))]

# Subset weekly (strategy) and daily (monitoring) to the same symbols
P <- sample_prices_weekly[, c("Date", syms), with = FALSE]
D <- sample_prices_daily[,  c("Date", syms), with = FALSE]

# Simple end-to-end example
mom <- calc_momentum(P, lookback = 12)
sel <- filter_top_n(mom, n = 3)
W   <- weight_equally(sel)
res <- run_backtest(P, W)

# Pick a benchmark that is guaranteed to exist in D
perf <- analyze_performance(res, D, benchmark_symbol = syms[1])
print(perf)
summary(perf)
}
