% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcn_plots.R
\name{plot_RTPeakWidth}
\alias{plot_RTPeakWidth}
\title{Plot RT peak width over time}
\usage{
plot_RTPeakWidth(data, x_lim, y_lim)
}
\arguments{
\item{data}{A data.frame with columns 'fc.raw.file', 'RT', 'peakWidth'}

\item{x_lim}{Plot range of x-axis}

\item{y_lim}{Plot range of y-axis}
}
\value{
GGplot object
}
\description{
The input is a data.frame with already averaged counts over binned RT-slices.
}
\examples{

 data = data.frame(fc.raw.file = rep(c("file A", "file B", "file C"), each=81),
                   RT = c(20:100),
                   peakWidth = c(rnorm(81, mean=20), rnorm(81, mean=10), rnorm(81, mean=30)))
 plot_RTPeakWidth(data, c(10, 100), c(0, 40))

}
