% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LDAopt_Ext.R
\name{LDAopt_Ext}
\alias{LDAopt_Ext}
\title{PP optimization using LDA index}
\usage{
LDAopt_Ext(origclass, origdata, q = 1, weight = TRUE, ...)
}
\arguments{
\item{origclass}{Factor or numeric vector containing the class labels for each observation.}

\item{origdata}{Numeric matrix or data frame containing the predictor variables without 
class information. Each row represents an observation and each column represents a variable.}

\item{q}{Integer specifying the dimension of the projection space. Default is 1 for 
1-dimensional projection.}

\item{weight}{Logical indicating whether to use weighted LDA index calculation. 
Default is \code{TRUE}.}

\item{...}{Additional arguments to be passed to internal optimization methods.}
}
\value{
An object of class \code{"PPoptim"}, which is a list containing:
\item{indexbest}{Numeric value representing the maximum LDA index achieved by the 
  optimal projection. Higher values indicate better class separation.}
\item{projbest}{Numeric matrix of optimal projection coefficients with dimensions 
  \code{ncol(origdata)} by \code{q}. Each column represents an optimal projection 
  direction that maximizes the LDA index for class separation.}
\item{origclass}{The original class information vector passed as input, preserved 
  for reference.}
\item{origdata}{The original data matrix without class information, preserved 
  for reference.}
}
\description{
Projection Pursuit Optimization Using LDA Index
}
\details{
Finds the q-dimensional optimal projection using the Linear Discriminant Analysis (LDA) 
projection pursuit index. This implementation follows the method described in PPtree.


The LDA projection pursuit index measures class separation by maximizing the ratio 
of between-class variance to within-class variance in the projected space. This 
function:
\enumerate{
  \item Calls \code{LDAopt} to find the optimal q-dimensional projection directions
  \item Evaluates the LDA index for the optimal projection using \code{LDAindex2}
  \item Returns both the projection matrix and its associated index value
}

When \code{weight = TRUE}, the index calculation accounts for class proportions, 
giving appropriate weight to each class in the optimization.
}
\references{
Lee, EK., Cook, D., Klinke, S., and Lumley, T. (2005) 
Projection Pursuit for Exploratory Supervised Classification, 
Journal of Computational and Graphical Statistics, 14(4):831-846.
}
\seealso{
\code{\link{PDAopt_Ext}}, \code{\link{findproj_Ext}}
}
