% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{epilepsy_drug_qol_df}
\alias{epilepsy_drug_qol_df}
\title{SANAD Epilepsy Drug Treatment Quality of Life Study}
\format{
A data frame with 1,852 observations and 9 variables:
\describe{
  \item{id}{Integer: Patient identification number}
  \item{with.time}{Numeric: Time to withdrawal/discontinuation (days)}
  \item{trt}{Factor with 2 levels: Treatment group (carbamazepine/lamotrigine)}
  \item{with.status}{Integer: Withdrawal status indicator}
  \item{time}{Numeric: Assessment time point (days since baseline)}
  \item{anxiety}{Numeric: Anxiety score (from QoL measure)}
  \item{depress}{Numeric: Depression score (from QoL measure)}
  \item{aep}{Numeric: Adverse effects profile score}
  \item{with.status2}{Numeric: Alternative withdrawal coding}
}
}
\source{
Data taken from the joineRML package version 0.4.7. Original study:
Marson, A.G., et al. (2007) The SANAD study of effectiveness of carbamazepine,
gabapentin, lamotrigine, oxcarbazepine, or topiramate for treatment of partial
epilepsy: an unblinded randomised controlled trial. \emph{The Lancet}, 369(9566), 1000-1015.
}
\usage{
data(epilepsy_drug_qol_df)
}
\description{
This dataset, epilepsy_drug_qol_df, is a data frame containing quality of life
measurements from the SANAD randomized controlled trial comparing carbamazepine
and lamotrigine in 544 epilepsy patients. QoL assessments were collected at
baseline, 3 months, 1 year and 2 years using validated instruments.
}
\details{
The dataset name has been kept as 'epilepsy_drug_qol_df' to avoid confusion
with other datasets in the R ecosystem. This naming convention helps distinguish
this dataset as part of the NeuroDataSets package. The suffix 'df' indicates
that the dataset is a data frame. The original content has not been modified.
}
