% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Perks.r
\name{Perks}
\alias{Perks}
\alias{dperks}
\alias{pperks}
\alias{qperks}
\alias{rperks}
\alias{hperks}
\title{Perks Distribution}
\usage{
dperks(x, alpha, beta, log = FALSE)
pperks(q, alpha, beta, lower.tail = TRUE, log.p = FALSE)
qperks(p, alpha, beta, lower.tail = TRUE, log.p = FALSE)
rperks(n, alpha, beta)
hperks(x, alpha, beta)

dperks(x, alpha, beta, log = FALSE)

pperks(q, alpha, beta, lower.tail = TRUE, log.p = FALSE)

qperks(p, alpha, beta, lower.tail = TRUE, log.p = FALSE)

rperks(n, alpha, beta)

hperks(x, alpha, beta)
}
\arguments{
\item{x, q}{numeric vector of quantiles (x, q)}

\item{alpha}{positive numeric parameter}

\item{beta}{positive numeric parameter}

\item{log}{logical; if TRUE, returns log-density}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
\eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities are given as log(p)}

\item{p}{numeric vector of probabilities (0 < p < 1)}

\item{n}{number of observations (integer > 0)}
}
\value{
\itemize{
  \item \code{dperks}: numeric vector of (log-)densities
  \item \code{pperks}: numeric vector of probabilities
  \item \code{qperks}: numeric vector of quantiles
  \item \code{rperks}: numeric vector of random variates
  \item \code{hperks}: numeric vector of hazard values
}
}
\description{
Provides density, distribution, quantile, random generation,
and hazard functions for the Perks distribution.
}
\details{
The Perks distribution is parameterized by the parameters
\eqn{\alpha > 0} and \eqn{\beta > 0}.


The Perks distribution has CDF:

\deqn{
F(x; \alpha, \beta) =
\quad 1 - \left( {\frac{{1 + \alpha }}{{1 + \alpha {e^{\beta x}}}}} \right)
\, ; \quad x \ge 0.
}

where \eqn{\alpha} and \eqn{\beta} are the parameters.

The following functions are included:
\itemize{
  \item \code{dperks()} — Density function
  \item \code{pperks()} — Distribution function
  \item \code{qperks()} — Quantile function
  \item \code{rperks()} — Random generation
  \item \code{hperks()} — Hazard function
}
}
\examples{
x <- seq(0.1, 2.0, 0.1)
dperks(x, 5.0, 1.5)
pperks(x, 5.0, 1.5)
qperks(0.5, 5.0, 1.5)
rperks(10, 5.0, 1.5)
hperks(x, 5.0, 1.5)

# Data
x <- conductors
# ML estimates
params = list(alpha=4.5967e-4, beta=1.1077)
#P–P (probability–probability) plot
pp.plot(x, params = params, pfun = pperks, fit.line=TRUE)

#Q-Q (quantile–quantile) plot 
qq.plot(x, params = params, qfun = qperks, fit.line=TRUE)

# Goodness-of-Fit(GoF) and Model Diagnostics 
out <- gofic(x, params = params,
             dfun = dperks, pfun=pperks, plot=TRUE)
print.gofic(out)

}
\references{
Richards, S.J. (2008). 
Applying survival models to pensioner mortality data. 
\emph{Bra. Actuarial Journal}, \bold{14}, 257--303.

Chaudhary, A.K., & Kumar, V. (2013). 
A Bayesian Analysis of Perks Distribution via Markov Chain Monte Carlo 
Simulation. \emph{Nepal Journal of Science and Technology}, \bold{14(1)},
153--166.   \doi{10.3126/njst.v14i1.8936}

Richards, S. J. (2012). 
A handbook of parametric survival models for actuarial use. 
\emph{Scandinavian Actuarial Journal}, 1--25.
}
