% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.r
\name{combine.morpho}
\alias{combine.morpho}
\title{Combine Two Morpho Objects}
\usage{
combine.morpho(x, y)
}
\arguments{
\item{x}{A `morpho` object.}

\item{y}{A `morpho` object.}
}
\value{
A combined `morpho` object.
}
\description{
This function merges two `morpho` objects, combining their sequences,
model parameters, and transition histories, while ensuring tree and fossil
consistency.
}
\examples{
phy <- ape::rtree(10)

# simulate characters along the branches of the tree
morpho1 <-  sim.morpho(tree = phy,
                           k = c(2,3,4),
                           trait.num = 20,
                           ancestral = TRUE,
                           partition = c(10,5,5),
                           ACRV = "gamma",
                           variable = TRUE,
                           ACRV.ncats = 4,
                           define.Q = NULL)

morpho2 <-  sim.morpho(tree = phy,
                           k = c(2,3,4),
                           trait.num = 20,
                           ancestral = TRUE,
                           partition = c(10,5,5),
                           ACRV = "gamma",
                           variable = TRUE,
                           ACRV.ncats = 4,
                           define.Q = NULL)

combined <- combine.morpho(morpho1, morpho2)
}
