% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/babel-import.R
\name{import_jpg1}
\alias{import_jpg1}
\title{Extract outline coordinates from a single .jpg file}
\usage{
import_jpg1(
  jpg.path,
  auto.notcentered = TRUE,
  fun.notcentered = NULL,
  threshold = 0.5,
  ...
)
}
\arguments{
\item{jpg.path}{vector of paths corresponding to the .jpg files to import, such as
those obtained with \link{list.files}.}

\item{auto.notcentered}{logical if TRUE random locations will be used until
one of them is (assumed) to be within the shape (because it corresponds to a black pixel) and only if
the middle point is not black;
if FALSE a \link{locator} will be called, and you will have to click on a
point within the shape.}

\item{fun.notcentered}{NULL by default but can accept a function that, when passed with an imagematrix and returns
a numeric of length two that corresponds to a starting point on the imagematrix for the Conte
algorithm. A \code{while} instruction wraps it, so the function may be wrong in proposing this
starting position. See the examples below for a quick example.}

\item{threshold}{the threshold value use to binarize the images. Above, pixels
are turned to 1, below to 0.}

\item{...}{arguments to be passed to \link{read.table}, eg. 'skip', 'dec', etc.}
}
\value{
a matrix of (x; y) coordinates that can be passed to Out
}
\description{
Used to import outline coordinates from .jpg files. This function is used for
single images and is wrapped by \link{import_jpg}. It relies itself on \link{import_Conte}
}
\details{
jpegs can be provided either as RVB or as 8-bit greylevels or monochrome.
The function binarizes pixels values using the 'threshold' argument. It will try to start to
apply the \link{import_Conte} algorithm from the center of
the image and 'looking' downwards for the first black/white 'frontier' in
the pixels. This point will be the first of the outlines. The latter may be useful
if you align manually the images and if you want to retain this information
in the consequent morphometric analyses.

If the point at the center of the
image is not within the shape, i.e. is 'white' you have two choices defined by
the 'auto.notcentered' argument. If it's TRUE, some random starting points
will be tried until on of them is 'black' and within the shape; if FALSE
you will be asked to click on a point within the shape.

If some pixels on the borders are not white, this functions adds a 2-pixel
border of white pixels; otherwise \link{import_Conte} would fail and return an error.

Finally, remember that if the images are not in your working directory,
\link{list.files} must be called with the argument \code{full.names=TRUE}!

Note that the use of the \code{fun.notcentered} argument will probably leads to serious headaches
and will probably imply the dissection of these functions: \link{import_Conte}, \link{img_plot} and
\code{import_jpg} itself
}
\note{
Note this function will be deprecated from Momocs
when \code{Momacs} and \code{Momit}
will be fully operationnal.
}
\seealso{
\link{import_jpg}, \link{import_Conte}, \link{import_txt}, \link{lf_structure}.
See also Momocs' vignettes for data import.

Other import functions: 
\code{\link{import_Conte}()},
\code{\link{import_StereoMorph_curve1}()},
\code{\link{import_jpg}()},
\code{\link{import_tps}()},
\code{\link{import_txt}()},
\code{\link{pix2chc}()}
}
\concept{import functions}
