% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exptab.R
\name{exptab}
\alias{exptab}
\title{Esporta una o piu' tabelle in un unico file csv (standard italiano)}
\usage{
exptab(tab, file, dids = names(tab), aggiungi = FALSE, ...)
}
\arguments{
\item{tab}{lista degli oggetti (table); se la lista è con nomi, questi saranno
utilizzati come didascalie}

\item{file}{nome del file di esportazione (con estensione csv)}

\item{dids}{vettore carattere con le discalie delle tabelle;
per default, è costituito dal nome degli elementi della lista}

\item{aggiungi}{aggiunge le tabelle ad un file esistente (come append), logico}

\item{...}{altri argomenti ereditati \code{\link[utils]{write.table}}}
}
\value{
file in formato csv con le tabelle
}
\description{
Esportazione semplificata di più tabelle in formato csv in uno stesso file
con \code{\link[utils]{write.table}}, e
secondo lo standard Excel in lingua italiana:
sep = ";",
dec = "," (separatore di decimali = virgola), NA = "" (celle vuote),
row.names = TRUE,
col.names = NA (per le colonne nel file csv).
}
\examples{
\dontrun{
data("MYSLID")
tab1 = tabfreq(MYSLID$Genere)
tab2 = tabcont(MYSLID$Lingua, MYSLID$Genere)
# una tabella
exptab(list(tab1), file = "tabelle.csv")
# tabelle diverse con didascalie
exptab(list(tab1, tab2), file = "tabelle.csv",
        dids = c("Genere", "Lingua parlata per Genere"),
        aggiungi = TRUE)
}
}
