% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/registration.R
\name{cpd}
\alias{cpd}
\title{cpd}
\usage{
cpd(
  X,
  Y,
  w = 0,
  weights = NULL,
  scale = FALSE,
  maxIter = 100,
  subsample = NULL,
  tol = 1e-04,
  rotation.only = FALSE
)
}
\arguments{
\item{X}{reference point set, a N x D matrix}

\item{Y}{point set to transform, a M x D matrix,}

\item{w}{noise weight in the range [0, 1)}

\item{weights}{a M x N matrix of point correspondence weights}

\item{scale}{logical (default: FALSE), whether to use scaling}

\item{maxIter}{maximum number of iterations to perform (default: 100)}

\item{subsample}{can be set either to a number in [0,1] representing the fraction of points to randomly 
select or a list with vector elements X and Y containing indices of points to select in X and Y}

\item{tol}{tolerance for determining convergence}

\item{rotation.only}{logical (default: FALSE), if TRUE, don't perform translation}
}
\value{
a list of
\itemize{
   \item Y: transformed point set, 
   \item R: rotation matrix, 
   \item t: translation vector, 
   \item s: scaling factor, 
   \item P: matrix of correspondence probabilities between the two point sets,
   \item sigma: final variance,
   \item iter: number of iterations performed,
   \item converged: boolean, whether the algorithm has converged.
}
}
\description{
Affine and rigid registration of two point sets using the coherent point drift algorithm. 
See: Myronenko A., Song X. (2010): "Point-Set Registration: Coherent Point Drift",
IEEE Trans. on Pattern Analysis and Machine Intelligence, vol. 32, issue 12, pp. 2262-2275.
}
\examples{
data.file1 <- system.file("test_data", "parasaurolophusA.txt", package = "LOMAR",
 mustWork = TRUE)
PS1 <- read.csv(data.file1, sep = '\t', header = FALSE)
data.file2 <- system.file("test_data", "parasaurolophusB.txt", package = "LOMAR",
 mustWork = TRUE)
PS2 <- read.csv(data.file2, sep = '\t', header = FALSE)
transformation <- cpd(PS1, PS2, maxIter = 10, tol = 1e-3)
\dontrun{
# Visualize registration outcome
library(rgl)
plot3d(PS1, col = "blue")
points3d(PS2, col = "green")
points3d(transformation[['Y']], col = "magenta")
}
}
