% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overwrite_functions.R
\name{residuals.LBBNN_Net}
\alias{residuals.LBBNN_Net}
\title{Residuals from LBBNN fit}
\usage{
\method{residuals}{LBBNN_Net}(object, type = c("response"), ...)
}
\arguments{
\item{object}{An object of class \code{LBBNN_Net}.}

\item{type}{Currently only 'response' is implemented i.e. y_true - y_predicted.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A numeric vector of residuals (\code{y_true - y_predicted})
}
\description{
Residuals from an object of the \code{LBBNN_Net} class.
}
\examples{
\donttest{ 
x<-torch::torch_randn(3,2) 
b <- torch::torch_rand(2)
y <- torch::torch_matmul(x,b)
train_data <- torch::tensor_dataset(x,y)
train_loader <- torch::dataloader(train_data,batch_size = 3,shuffle=FALSE)
problem<-'regression'
sizes <- c(2,1,1) 
inclusion_priors <-c(0.9,0.2) 
inclusion_inits <- matrix(rep(c(-10,10),2),nrow = 2,ncol = 2)
stds <- c(1.0,1.0)
model <- LBBNN_Net(problem,sizes,inclusion_priors,stds,inclusion_inits,flow = FALSE,
input_skip = TRUE)
train_LBBNN(epochs = 1,LBBNN = model, lr = 0.01,train_dl = train_loader)
residuals(model)
}
}
