% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardisedsolution.R
\name{standardisedsolution}
\alias{standardisedsolution}
\alias{standardisedSolution}
\alias{standardizedsolution}
\alias{standardizedSolution}
\title{Standardised solution of a latent variable model}
\usage{
standardisedsolution(
  object,
  type = "std.all",
  se = TRUE,
  ci = TRUE,
  level = 0.95,
  postmedian = FALSE,
  postmode = FALSE,
  cov.std = TRUE,
  remove.eq = TRUE,
  remove.ineq = TRUE,
  remove.def = FALSE,
  nsamp = 250,
  ...
)

standardisedSolution(
  object,
  type = "std.all",
  se = TRUE,
  ci = TRUE,
  level = 0.95,
  postmedian = FALSE,
  postmode = FALSE,
  cov.std = TRUE,
  remove.eq = TRUE,
  remove.ineq = TRUE,
  remove.def = FALSE,
  nsamp = 250,
  ...
)

standardizedsolution(
  object,
  type = "std.all",
  se = TRUE,
  ci = TRUE,
  level = 0.95,
  postmedian = FALSE,
  postmode = FALSE,
  cov.std = TRUE,
  remove.eq = TRUE,
  remove.ineq = TRUE,
  remove.def = FALSE,
  nsamp = 250,
  ...
)

standardizedSolution(
  object,
  type = "std.all",
  se = TRUE,
  ci = TRUE,
  level = 0.95,
  postmedian = FALSE,
  postmode = FALSE,
  cov.std = TRUE,
  remove.eq = TRUE,
  remove.ineq = TRUE,
  remove.def = FALSE,
  nsamp = 250,
  ...
)
}
\arguments{
\item{object}{An object of class \link{INLAvaan}.}

\item{type}{If \code{"std.lv"}, the standardized estimates are
on the variances of the (continuous) latent variables only.
If \code{"std.all"}, the standardized estimates are based
on both the variances of both (continuous) observed and latent variables.
If \code{"std.nox"}, the standardized estimates are based
on both the variances of both (continuous) observed and latent variables, 
but not the variances of exogenous covariates.}

\item{se}{Logical. If TRUE, standard errors for the standardized parameters
will be computed, together with a z-statistic and a p-value.}

\item{ci}{If \code{TRUE}, simple symmetric confidence intervals are added to 
the output}

\item{level}{The confidence level required.}

\item{postmedian}{Logical; if TRUE, include posterior median in estimates.}

\item{postmode}{Logical; if TRUE, include posterior mode in estimates.}

\item{cov.std}{Logical. If TRUE, the (residual) observed
covariances are scaled by the square root of the `Theta' diagonal elements, and
the (residual) latent covariances are scaled by the square root of the `Psi'
diagonal elements. If FALSE, the (residual) observed covariances
are scaled by the square root of the diagonal elements of the observed
model-implied covariance matrix (Sigma), and the (residual) latent covariances
are scaled by the square root of diagonal elements of the model-implied
covariance matrix of the latent variables.}

\item{remove.eq}{Logical. If TRUE, filter the output by removing all rows 
containing equality constraints, if any.}

\item{remove.ineq}{Logical. If TRUE, filter the output by removing all
rows containing inequality constraints, if any.}

\item{remove.def}{Logical. If TRUE, filter the ouitput by removing all
rows containing parameter definitions, if any.}

\item{nsamp}{The number of samples to draw from the approximate posterior
distribution for the calculation of standardised estimates.}

\item{...}{Additional arguments sent to \code{lavaan::standardizedSolution()}.}
}
\value{
A \code{data.frame} containing standardised model parameters.
}
\description{
Standardised solution of a latent variable model
}
\examples{
HS.model <- "
  visual  =~ x1 + x2 + x3
  textual =~ x4 + x5 + x6
  speed   =~ x7 + x8 + x9
"
utils::data("HolzingerSwineford1939", package = "lavaan")

# Fit a CFA model with standardised latent variables
fit <- acfa(HS.model, data = HolzingerSwineford1939, test = "none")
standardisedsolution(fit, nsamp = 100)
}
