% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NoPricesInversionModel.R
\name{NoPricesInversionModel}
\alias{NoPricesInversionModel}
\title{Function to invert model, so amenities, wages, productivities, and development density
are chosen to match model to data. This function requires data on the amount of floorspace.}
\usage{
NoPricesInversionModel(
  N,
  L_i,
  L_j,
  K,
  t_ij,
  alpha = 0.7,
  beta = 0.7,
  theta = 7,
  delta = 0.3585,
  rho = 0.9094,
  lambda = 0.01,
  epsilon = 0.01,
  mu = 0.3,
  eta = 0.15,
  nu_init = 0.05,
  tol = 10^-10,
  maxiter = 1000,
  FS
)
}
\arguments{
\item{N}{Integer - Number of locations.}

\item{L_i}{Nx1 matrix - Number of residents in each location.}

\item{L_j}{Nx1 matrix - Number of workers in each location.}

\item{K}{Nx1 matrix - Land area}

\item{t_ij}{NxN matrix - Travel times across all possible locations.}

\item{alpha}{Float - Utility parameter that determines preferences for
consumption.}

\item{beta}{Float - Output elasticity wrt labor}

\item{theta}{Float - Commuting elasticity and migration elasticity.}

\item{delta}{Float - Decay parameter agglomeration}

\item{rho}{Float - Decay parameter congestion}

\item{lambda}{Float - Agglomeration force}

\item{epsilon}{Float - Parameter that transforms travel times to commuting costs}

\item{mu}{Float - Floorspace prod function: output elasticity wrt capital, 1-mu wrt land.}

\item{eta}{Float - Congestion force}

\item{nu_init}{Float - Convergence parameter to update wages.
Default nu=0.01.}

\item{tol}{Int - tolerance factor}

\item{maxiter}{Integer - Maximum number of iterations for convergence.
Default maxiter=1000.}

\item{FS}{Nx1 array - Total floorspace in the location}
}
\value{
A list containing the equilibrium values for the variables of the model. The reported variables are population (Li), employment (Lj),
normalized rents (Q_norm), endogenous amenities (A), exogenous amenities (a), endogenous productivities (B), exogenous productivities (b), wages (w),
density of development (varphi), aggregate welfare (U), share of commercial floorspace (ttheta), floorspace (FS), residential floorspace (FS_r) and commercial floorspace (FS_f)
}
\description{
Function to invert model, so amenities, wages, productivities, and development density
are chosen to match model to data. This function requires data on the amount of floorspace.
}
