% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_state_comparison.R
\name{plot_state_comparison}
\alias{plot_state_comparison}
\title{State deuterium uptake comparison}
\usage{
plot_state_comparison(
  uptake_dat,
  skip_amino = 0,
  theoretical = FALSE,
  fractional = FALSE,
  line_size = 1.5,
  all_times = FALSE,
  time_t = NULL,
  interactive = getOption("hadex_use_interactive_plots")
)
}
\arguments{
\item{uptake_dat}{data produced by \code{\link{calculate_state_uptake}} 
function}

\item{skip_amino}{\code{integer}, indicator how many amino acids from the N-terminus 
should be omitted}

\item{theoretical}{\code{logical}, indicator if values are 
calculated using theoretical controls}

\item{fractional}{\code{logical}, indicator if values are shown 
in fractional form}

\item{line_size}{line size for the plot}

\item{all_times}{\code{logical}, indicator is all all time should
be plotted next to each other}

\item{time_t}{chosen time point}

\item{interactive}{\code{logical}, whether plot should have an interactive 
layer created with with ggiraph, which would add tooltips to the plot in an
interactive display (HTML/Markdown documents or shiny app)}
}
\value{
a \code{ggplot} object
}
\description{
Comparison plot of deuterium uptake values in time
point for biological states.
}
\details{
The function \code{\link{plot_state_comparison}} generates
a comparison plot, presenting deuterium uptake values of peptides 
from selected protein in selected biological states at one time point 
of measurement at once. 
On X-axis there is a position in a sequence, with length of a segment 
of each peptide representing its length. On Y-axis there 
is deuterium uptake in selected form. Error bars represents the combined
and propagated uncertainty.
}
\examples{
uptake_dat <- calculate_state_uptake(alpha_dat)
plot_state_comparison(uptake_dat)

plot_state_comparison(uptake_dat, all_times = TRUE)
plot_state_comparison(uptake_dat, fractional = TRUE, all_times = TRUE)

}
\seealso{
\code{\link{read_hdx}}
\code{\link{calculate_state_uptake}}
}
