% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_back_exchange.R
\name{calculate_back_exchange}
\alias{calculate_back_exchange}
\title{Back exchange estimation}
\usage{
calculate_back_exchange(
  dat,
  protein = dat[["Protein"]][1],
  states = unique(dat[["State"]]),
  time_100 = max(dat[["Exposure"]])
)
}
\arguments{
\item{dat}{data imported by the \code{\link{read_hdx}} function}

\item{protein}{selected protein}

\item{states}{selected biological states for given protein}

\item{time_100}{time point of measurement for fully 
deuterated sample}
}
\value{
a \code{\link{data.frame}} object
}
\description{
Calculates back-exchange for a state
}
\details{
Back-exchange is a reverse exchange phenomenon, important 
to acknowledge when working with HDX data. This function calculates
back-exchange values for one biological state of the selected protein.
For visualization of back-exchange data use \code{\link{plot_coverage_heatmap}}
with displayed value specified as `back-exchange`.
For the definition of back-exchange see the `vignette("datafiles")`.
}
\examples{
head(calculate_back_exchange(alpha_dat))

}
\seealso{
\code{\link{read_hdx}}
\code{\link{plot_coverage_heatmap}}
}
