% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HNPclassifier.r
\name{probability_to_score_2}
\alias{probability_to_score_2}
\title{T2 Calculation
Create T2 scoring function as ratio P(class 2)/P(class 3)}
\usage{
probability_to_score_2(model, method)
}
\arguments{
\item{model}{A fitted model returned by \code{base_function} or equivalent.}

\item{method}{Character string specifying the model family used: one of
'svm', 'randomforest', or 'logistic'.}
}
\value{
A function of the form \code{function(X) numeric}, where \code{X} is a
data.frame of features and the returned numeric vector are T2 scores.
}
\description{
Return a function that produces the ratio of predicted
probabilities P(Y=2|X) / P(Y=3|X), with safeguards for zeros/NA and
infinite values. Works with the supported \code{method}s used by \code{base_function}.
}
\examples{
set.seed(123)
x <- data.frame(a = rnorm(20), b = rnorm(20))
y <- factor(sample(c("1","2","3"), 20, TRUE))
model <- base_function(x, y, method = 'randomforest')
T2 <- probability_to_score_2(model, method = 'randomforest')
newx <- data.frame(a = rnorm(5), b = rnorm(5))
scores <- T2(newx)
}
\references{
Lijia Wang, Y. X. Rachel Wang, Jingyi Jessica Li, and Xin Tong (2024).
"Hierarchical Neyman-Pearson Classification for Prioritizing Severe Disease
Categories in COVID-19 Patient Data."
\emph{Journal of the American Statistical Association}, 119(545), 39-51.
\doi{10.1080/01621459.2023.2270657}
}
