% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HNPclassifier.r
\name{hnp_upper_bound}
\alias{hnp_upper_bound}
\title{Upper Bound of the ith Threshold (Optimal ith Threshold)}
\usage{
hnp_upper_bound(S_it, level, delta_i, score_functions, thresholds, i)
}
\arguments{
\item{S_it}{The left-out class-i samples.}

\item{level}{(alpha) desired control level for the ith under
classification error.}

\item{delta_i}{ith tolerance parameter.}

\item{score_functions}{A list of score functions (T_1, ..., T_i).}

\item{thresholds}{Numeric vector of length \code{i - 1} with thresholds for
previously evaluated classes; ignored when \code{i == 1}.}

\item{i}{Class-i.}
}
\value{
t_i_bar Optimal ith threshold.
}
\description{
Compute the optimal threshold for class i using score
functions and confidence bounds, given tolerance and under classification
error level.
}
\examples{
set.seed(123)
n <- 200
S_it <- data.frame(
  feature1 = rnorm(n, mean = 2, sd = 1),
  feature2 = runif(n, min = 0, max = 5)
)
level <- 0.05
delta_i <- 0.01
score_functions <- list(
  function(data) runif(nrow(data)),
  function(data) runif(nrow(data))
)
thresholds <- c(2.5, NA)
i <- 1
t_i_bar <- hnp_upper_bound(S_it, level, delta_i, score_functions, thresholds, i)

}
\references{
Lijia Wang, Y. X. Rachel Wang, Jingyi Jessica Li, and Xin Tong (2024).
"Hierarchical Neyman-Pearson Classification for Prioritizing Severe Disease
Categories in COVID-19 Patient Data."
\emph{Journal of the American Statistical Association}, 119(545), 39-51.
\doi{10.1080/01621459.2023.2270657}
}
