safe_dmv <-
function(x, mu, sigma) {
  # Try using the fast dmvn() function
  result <- tryCatch({
    dmvn(x, mu, sigma)  # Use fast dmvn() from mvnfast
  }, error = function(e) {
    # cat("dmvn() failed. Falling back to dmvnorm().\n")
    return(dmvnorm(x, mean = mu, sigma = sigma))  # Use stable dmvnorm()
  })
  
  return(result)
}
