% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epiyw.R
\name{epiyw_to_date}
\alias{epiyw_to_date}
\title{Convert a epiyearweek to date format}
\usage{
epiyw_to_date(epiyw, weekday = "Monday")
}
\arguments{
\item{epiyw}{An epiyear-epiweek character vector in 'YYYY-WW' format.}

\item{weekday}{Starting day of the epiweek. Defaults to Monday.}
}
\value{
The converted epiyearweeks to dates.
}
\description{
The conversion is done following the ISO 8601 standard,
whereby the first week of the year is the one that contains at least
four days of the  new year. This coincides with the approach taken
by \code{lubridate::epiweek} and \code{lubridate::isoweek} but may not
coincide with other definitions of epidemiological weeks.
}
\examples{
epiyw <- c("2025-01", "2025-10", "2025-20", "2025-30")
epiyw_to_date(epiyw)
}
