% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bouvard_vta.R
\name{bouvard_vta}
\alias{bouvard_vta}
\title{Volume Estimation Using the Bouvard Method}
\usage{
bouvard_vta(data, output = NULL)
}
\arguments{
\item{data}{A data frame containing tree measurements. Must include:
\itemize{
\item \code{species_code}: species name in uppercase Latin format (e.g. \code{"QUERCUS_SP"}).
\item \code{dbh}: diameter at breast height (cm).
\item \code{htot}: total tree height (m).
}}

\item{output}{Optional file path where the resulting data frame should be
exported as a CSV. If NULL (default), no file is written.
Export is handled by the utility function \code{export_output()} and
failures trigger warnings without interrupting execution.}
}
\value{
A data frame with the original input columns plus one new output:
\itemize{
\item \code{bouvard_vta}: aerial total volume (m3). Computed only for \code{"QUERCUS_SP"},
otherwise not created.
}
}
\description{
Computes aerial total volume (\code{bouvard_vta}) according to the Bouvard method.
The function validates input data, ensures required columns are present,
and applies the formula only to species \code{"QUERCUS_SP"}.
}
\details{
\itemize{
\item Input \code{dbh} must be in centimeters (cm). The function converts it internally to meters.
\item Input \code{htot} must be in meters (m).
\item Formula for aerial total volume (only \code{"QUERCUS_SP"}):
\deqn{bouvard_vta = 0.5 * (dbh/100)^2 * htot}
\item Resulting volumes are expressed in cubic meters (m3).
\item If required columns are missing or non-numeric, the function stops with an error.
\item The output column is created only if at least one \code{"QUERCUS_SP"} row is present,
otherwise a warning message is displayed and no column is added.
}
}
\examples{
df <- data.frame(
  species_code = c("QUERCUS_SP", "PICEA_ABIES", "FAGUS_SYLVATICA"),
  dbh = c(30, 25, 40),   
  htot = c(20, 18, 22)   
)
bouvard_vta(df)

}
