% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GCubeR.r
\name{GCubeR}
\alias{GCubeR}
\title{GCubeR main workflow}
\usage{
GCubeR(data, output = NULL, volume_col = NULL)
}
\arguments{
\item{data}{A \code{data.frame} with at least:
\itemize{
\item \code{species_code}: tree species identifier (character),
\item \code{c150}, \code{c130}, or \code{dbh}: stem circumference or diameter,
\item optionally \code{htot} (total height) and \code{hdom} (dominant height).
}}

\item{output}{Optional file path where the resulting data frame should be
exported as a CSV. If NULL (default), no file is written.
Export is handled by the utility function \code{export_output()} and
failures trigger warnings without interrupting execution.}

\item{volume_col}{Optional character string naming the column of volume to use
for plotting in \code{plot_by_class}. If NULL (default), the function
will automatically select the first available column among:
\code{dagnelie_vc22_1}, \code{dagnelie_vc22_1g}, \code{dagnelie_vc22_2},
\code{dagnelie_br}, \code{vallet_vta}, \code{vallet_vc22}, \code{bouvard_vta},
\code{rondeux_vc22}, \code{rondeux_vtot}, \code{algan_vta}, or \code{algan_vc22}.}
}
\value{
A \code{data.frame} identical to the input but augmented with:
\itemize{
\item \code{c130} and \code{dbh} (ensured to be present),
\item outputs from Dagnelie, Vallet, Algan, Rondeux, Bouvard functions,
\item biomass and carbon stock estimates.
}
}
\description{
This function takes a dataframe containing tree measurements (circumference,
diameter, height, species code) and enriches it by:
\enumerate{
\item Converting circumference at 1.50 m (\code{c150}) to circumference at 1.30 m (\code{c130}).
\item Adding diameter at breast height (\code{dbh}) if missing, or converting back to \code{c130}.
\item Applying a suite of allometric equations for volume, biomass, and carbon stock estimation.
}
}
\details{
Orchestrates the GCubeR pipeline by sequentially applying allometric
conversion and biomass/volume functions to a user-provided dataset.

The following functions are called in order:
\enumerate{
\item \code{c150_to_c130}
\item \code{add_c130_dbh}
\item \code{dagnelie_vc22_1}
\item \code{dagnelie_vc22_1g}
\item \code{dagnelie_vc22_2}
\item \code{dagnelie_br}
\item \code{vallet_vta}
\item \code{vallet_vc22}
\item \code{algan_vta_vc22}
\item \code{rondeux_vc22_vtot}
\item \code{bouvard_vta}
\item \code{biomass_calc}
}
}
\examples{
data <- data.frame(
  tree_id = 1:3,
  species_code = c("PINUS_SYLVESTRIS", "QUERCUS_RUBRA", "FAGUS_SYLVATICA"),
  c150 = c(145, NA, NA),
  c130 = c(NA, 156, NA),
  dbh  = c(NA, NA, 40),
  htot = c(25, 30, 28),
  hdom = c(NA, 32, NA)
)
GCubeR(data)

}
