#' Function to compute the weighted 1-dimensional kernel density estimator
#'
#' @param x output of the sLDA function
#' @param w An optional vector of weights (how much each observation contributes)
#' @importFrom graphics hist
#' @importFrom stats dnorm quantile
#' @return Returns an estimate of the probability density at each x[i]
#' @name kde
#' @keywords internal
kde <- function(x, w = NA){
  if(sum(is.na(w)) >0){
    w <- seq(1,1,length.out = length(x))
  }
  n <- 100
  r <- hist(x,n,plot = F)
  p <- ceiling((x - min(r$breaks)) / (r$breaks[2] - r$breaks[1]))
  mids <- r$mids
  p[p<1] <- 1
  p[p>length(mids)] <-length(mids)
  weights <- seq(0,0,length.out = length(mids))
  for(i in 1:length(mids)){
    weights[i] <- sum(w[p==i])
  }
  m <- sum(weights * mids) / sum(weights)
  s <- sqrt(sum((mids - m)^2) / sum(weights))
  h <- 0.9 * min(s, quantile(mids)[4] - quantile(mids)[2])* length(mids)^(-0.2)
  
  dist <- matrix(rep(mids,length(mids)),nrow=length(mids)) - matrix(rep(mids,length(mids)),nrow=length(mids),byrow = T)
  dens <- dnorm(dist / h)
  y <- apply(dens * matrix(rep(weights,length(mids)),nrow=length(mids),byrow=T), 1, sum) / h / sum(weights)
  
  y <- y[p]
  return(y)
}