% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversions.R
\name{reconstructed.tree.fossils.objects}
\alias{reconstructed.tree.fossils.objects}
\title{Returns tree and fossil objects that you can use to plot the reconstructed tree.}
\usage{
reconstructed.tree.fossils.objects(
  fossils,
  tree,
  rho = 1,
  tip_order = c("oldest_first", "youngest_first")
)
}
\arguments{
\item{fossils}{Fossils object.}

\item{tree}{Tree object.}

\item{rho}{Extant species sampling probability. Default = 1, will be disregarded if fossils object already contains extant samples.}

\item{tip_order}{Order of indexes to assign to the tips in the SA tree, either `oldest_first` (by default, indexes increase towards the present) or `youngest_first` 
(indexes increase towards the past).}
}
\value{
A list containing the reconstructed SA tree and fossil objects.
}
\description{
Note that for datasets containing extinct only samples (& rho = 0) the ages output are scaled so that the youngest sample = 0.
}
\examples{
# simulate tree
birth = 0.1
death = 0.05
tips = 10
t = TreeSim::sim.bd.taxa(tips, 1, birth, death)[[1]]

# simulate fossils
f = sim.fossils.poisson(rate = 0.3, tree = t)

# simulate extant samples
f = sim.extant.samples(f, tree = t, rho = 0.5)

# plot the complete tree
plot(f,t)

# generate tree & fossil objects corresponding to the reconstructed tree
out = reconstructed.tree.fossils.objects(f, t)
f.reconst = out$fossils
t.reconst = out$tree

# plot the reconstructed tree
plot(f.reconst, t.reconst)

}
