% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checks.R
\name{check_truncation_length}
\alias{check_truncation_length}
\title{Check and warn if truncation distribution is longer than observed time}
\usage{
check_truncation_length(stan_args, time_points)
}
\arguments{
\item{stan_args}{List of stan arguments including the data element with
delay information from \code{\link[=create_stan_delays]{create_stan_delays()}}}

\item{time_points}{Integer length of the observed time period
(t - seeding_time - horizon)}
}
\value{
Called for its side effects
}
\description{
Checks if the truncation distribution PMF is longer than the
observed time period (excluding seeding time and forecast horizon). The
truncation is applied to the observed time period in the Stan model, so
having a truncation distribution longer than this period means the tail of
the distribution will be used.
}
\keyword{internal}
