% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output.R
\name{to_latex}
\alias{to_latex}
\title{Convert Equation to LaTeX}
\usage{
to_latex(
  equation,
  variable = "Z",
  precision = 3,
  scientific_notation = TRUE,
  include_uncertainty = FALSE,
  se_values = NULL
)
}
\arguments{
\item{equation}{Fitted equation object.}

\item{variable}{Name of the dependent variable (for dZ/dt notation).}

\item{precision}{Number of decimal places for coefficients.}

\item{scientific_notation}{Use scientific notation for large/small coefficients.}

\item{include_uncertainty}{Include standard errors in parentheses.}

\item{se_values}{Named vector of standard errors (optional).}
}
\value{
Character string with LaTeX equation.
}
\description{
Converts a discovered equation to LaTeX format for publication.
}
\examples{
# Toy example using a linear model
data <- data.frame(Z = 1:10, dZ = 2 * (1:10) + 3)
model <- stats::lm(dZ ~ Z, data = data)

# Convert to LaTeX
latex_eq <- to_latex(model, variable = "Z")
cat(latex_eq)
}
