% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exploration.R
\name{explore_dynamics}
\alias{explore_dynamics}
\title{Comprehensive Dynamics Exploration}
\usage{
explore_dynamics(
  data,
  target,
  predictors = NULL,
  time = NULL,
  n_bins = 10,
  include = "all"
)
}
\arguments{
\item{data}{Data frame containing the time series.}

\item{target}{Name of the target variable (or its derivative).}

\item{predictors}{Character vector of predictor variable names.}

\item{time}{Name of the time column (auto-detected if NULL).}

\item{n_bins}{Number of bins for conditional analysis.}

\item{include}{Which plots to include: "all", or subset of
c("timeseries", "phase", "bivariate", "interactions").}
}
\value{
A list containing:
\itemize{
\item suggestions: Character vector of suggested functional forms
\item statistics: Data frame of diagnostic statistics
\item plots: List of ggplot objects (if available)
}
}
\description{
Generates a battery of diagnostic plots to explore the dynamical structure
of the data and suggests potential functional forms.
}
\examples{
\donttest{
# Toy example
data <- data.frame(
  time = 1:50,
  Z = sin(seq(0, 10, length.out = 50)),
  X = cos(seq(0, 10, length.out = 50))
)
data$dZ <- c(diff(data$Z)/diff(data$time), NA)
data <- na.omit(data)

result <- explore_dynamics(data, 
  target = "dZ",
  predictors = c("Z", "X")
)
print(result$suggestions)
}

}
