% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqcheck.R
\name{seqcheck}
\alias{seqcheck}
\title{runs raw data diagnostics for Elo rating}
\usage{
seqcheck(winner, loser, Date, draw = NULL, presence = NULL)
}
\arguments{
\item{winner}{either a factor or character vector with winner IDs of dyadic dominance interactions}

\item{loser}{either a factor or character vector with loser IDs of dyadic dominance interactions}

\item{Date}{character vector of form "YYYY-MM-DD" with the date of the respective interaction}

\item{draw}{logical, which interactions ended undecided (i.e. drawn or tied)? By default all \code{FALSE}, i.e. no undecided interactions occurred. Note that in this case, \code{winner}/\code{loser} values can be interchanged}

\item{presence}{optional data.frame, to supply data about presence and absence of individuals for part of the time the data collection covered. see details}
}
\value{
returns textual information about possible issues with the supplied data set, or states that data are fine for running with \code{\link{elo.seq}}
}
\description{
runs some diagnostics on the data supplied to \link{elo.seq}, to check whether \link{elo.seq} will run without errors
}
\details{
calender dates (for the sequence as well as in the first column of \code{presence}, if supplied) need to be in "YYYY-MM-DD" format!

\code{seqcheck} will return two types of messages: warnings and errors. Errors will result in the data NOT working when supplied to \code{elo.seq}, and need to be fixed. Warning message do not necessarily lead to failure of executing \code{elo.seq}. Note that by default \code{seqcheck} is part of \code{elo.seq}. If any error or warning is produced by \code{seqcheck}, these data will not work in \code{\link{elo.seq}}. Some warning (but not error) messages can be ignored (see below) and if the \code{runcheck} argument in \code{elo.seq} is set to \code{FALSE} Elo-ratings will be calculated properly in such cases.

The actual checks (and corresponding messages) that are performed are described in more detail here:

Most likely (i.e. in our experience), problems are caused by mismatches between the interaction data and the corresponding presence data.

Errors:\cr
\code{Presence starts AFTER data}: indicates that during interactions at the beginning of the sequence, no corresponding information was found in the presence data. Solution: augment presence data, or remove interactions until the date on which presence data starts

\code{Presence stops BEFORE data}: refers to the corresponding problem towards the end of interaction and presence data

\code{During the following interactions, IDs were absent...}: indicates that according to the presence data, IDs were absent (i.e. "0"), but interactions with them occured on the very date(s) according to the interaction data

\code{The following IDs occur in the data sequence but NOT...}: there is/are no columns corresponding to the listed IDs in the presence data

\code{There appear to be gaps in your presence (days missing?)...}: check whether your presence data includes a line for \emph{each date} starting from the date of the first interaction through to the date of the last interaction

Warnings:

\code{Presence continues beyond data}: indicates that presence and interaction data do not end on the same date.

\code{Presence starts earlier than data}: indicates that presence and interaction data do not start on the same date.

\code{The following IDs occur in the presence data but NOT...}: there are more ID columns in the presence data than IDs occuring in the interaction data

\code{Date column is not ordered}: The dates are not supplied in ascending order. \code{\link{elo.seq}} will still work but the results won't be reliable because the interactions were not in the correct sequence.

Other warnings/errors can result from inconsistencies in either the presence or sequence data, or be of a more general nature:

Errors:

\code{No 'Date' column found}: in the presence data, no column exists with the name/header "Date". Please rename (or add) the necessary column named "Date" to your presence data.

\code{At least one presence entry is not 1 or 0}: presence data must come in binary form, i.e. an ID was either present ("1") or absent ("0") on a given date. No \code{NA}s or other values are allowed.

\code{Your data vectors do not match in length}: at least one of the three mandatory arguments (winner, loser, Date) differs from one other in length. Consider handling your data in a data.frame, which avoids this error.

Warnings:

\code{IDs occur in the data with inconsistent capitalization}: because \code{R} is case-sensitive, "A" and "a" are considered different individuals. If such labelling of IDs is on purpose, ignore the warning and set \code{runcheck=FALSE} when calling \code{elo.seq()}

\code{There is (are) X case(s) in which loser ID equals winner ID}: winner and loser represent the same ID

\code{The following individuals were observed only on one day}: while not per se a problem for the calculation of Elo ratings, individuals that were observed only on one day (irrespective of the number of interactions on that day) cannot be plotted. \code{\link{eloplot}} will give a warning in such cases, too.
}
\examples{
data(adv)
seqcheck(winner = adv$winner, loser = adv$loser, Date = adv$Date)
data(advpres)
seqcheck(winner = adv$winner, loser = adv$loser, Date = adv$Date,
         presence = advpres)

# create faulty presence data
# remove one line from presence data
faultypres <- advpres[-1, ]
# make all individuals absent on one day
faultypres[5, 2:8] <- 0
# run check
seqcheck(winner = adv$winner, loser = adv$loser, Date = adv$Date,
         presence = faultypres)

# fix first error
faultypres <- rbind(faultypres[1, ], faultypres)
faultypres$Date[1] <- "2010-01-01"

# run check again
seqcheck(winner = adv$winner, loser = adv$loser, Date = adv$Date,
         presence = faultypres)

# fix presence on date for interaction number 6
faultypres[6, 2:8] <- 1

# run check again
seqcheck(winner = adv$winner, loser = adv$loser, Date = adv$Date,
         presence = faultypres)
# all good now
}
\author{
Christof Neumann
}
