% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createstartvalues.R
\name{createstartvalues}
\alias{createstartvalues}
\title{calculate start values from prior knowledge}
\usage{
createstartvalues(
  ranks = NULL,
  rankclasses = NULL,
  shape = 0.3,
  startvalue = 1000,
  k = 100
)
}
\arguments{
\item{ranks}{named vector, contains the ordinal ranks of all individuals for which such prior knowledge exists, names of the vector refer to the individual codes as they occur in the interaction sequence supplied to \code{\link{elo.seq}}}

\item{rankclasses}{list with four items, each representing a rank class in descending order, if a given rank class is empty supply it as \code{NULL}, see details and examples}

\item{shape}{numeric, between 0 and 1, by default \code{shape=0.3}. This value determines the 'steepness' of the initial values. Steepest is at \code{shape=0} and shallowest is at \code{shape=1}. See examples.}

\item{startvalue}{numeric, the rating value with which an individual starts into the rating process. By default \code{startvalue=1000}}

\item{k}{numeric, the \emph{k} factor that determines the maximum change in ratings. By default \code{k=100}}
}
\value{
list with three items:\cr
\item{res}{a named numeric vector with the startvalues to be supplied to \code{\link{elo.seq}}}
\item{k}{\emph{k} factor used}
\item{startvalue}{start value used}
}
\description{
calculate start values from prior knowledge
}
\details{
only one of \code{ranks} or \code{rankclasses} can be supplied.

if you wish to supply rank classes you need to supply four categories and it is assumed that the first list item is the highest class. If you have less than four rank classes, you still need to supply a list with four items and set those that you wish to ignore to \code{NULL}, see examples.
}
\examples{
# assuming a group with 7 individuals
# with four rank classes
myrankclasses <- list(alpha = "a", high=c("b", "c"), mid=c("d", "e"), low=c("f", "g"))
createstartvalues(rankclasses = myrankclasses)
# with two rank classes
myrankclasses2 <- list(class1 = NULL, high=c("a", "b", "c"), class3=NULL, low=c("d", "e", "f", "g"))
createstartvalues(rankclasses = myrankclasses2)

# with ordinal ranks
myranks <- 1:7; names(myranks) <- letters[1:7]
createstartvalues(ranks = myranks)
}
\references{
\insertRef{newton-fisher2017a}{EloRating}
}
\author{
Christof Neumann
}
