% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coresidence.R
\name{coresidence}
\alias{coresidence}
\title{coresidence summary}
\usage{
coresidence(eloobject)
}
\arguments{
\item{eloobject}{result from \code{\link{elo.seq}}}
}
\value{
a list with three items:
\describe{
 \item{\code{$global} (a numeric vector)}{
   \describe{
   \item{\code{n_int}}{total number of interactions}
   \item{\code{n_dyads}}{total number of dyads}
   \item{\code{prop_nocores}}{proportion of dyads that were never co-resident}
   \item{\code{mean_cores_prop}}{mean proportion over individuals of proportions of all other IDs the focal was co-resident with at some point}
   }
 }
 \item{\code{$dyads} (a data.frame)}{
   \describe{
   \item{\code{id1, id2}}{the IDs}
   \item{\code{n_int}}{number of interactions for dyad}
   \item{\code{cores_dur}}{the duration of co-residence}
   \item{\code{none_dur}}{the duration for neither ID being present (both are absent)}
   \item{\code{one_dur}}{the duration of time when one ID was present but not the other}
   }
 }
 \item{\code{$individuals} (a data.frame)}{
   \describe{
   \item{\code{id}}{the ID}
   \item{\code{n_int}}{number of interactions}
   \item{\code{presdays}}{days of presence}
   \item{\code{cores_n_ind}}{co-resident with these individuals at some point}
   \item{\code{cores_prop}}{proportion of individuals with which ID was co-resident}
   \item{\code{stints}}{number of continuous bouts of presence}
   }
 }
}
}
\description{
coresidence summary
}
\details{
This function provides a summary of the presence of individuals (and dyads) during the data sequence. This will be only informative if there was actually presence information supplied to \code{elo.seq}.
}
\examples{
set.seed(123)
IA <- randomsequence(nID = 10, avgIA = 20, presence = c(0.7, 0.8))
SEQ <- elo.seq(winner = IA$seqdat$winner, loser = IA$seqdat$loser, Date = IA$seqdat$Date,
               presence = IA$pres, runcheck = FALSE, progressbar = FALSE)
coresidence(SEQ)
}
\seealso{
\code{\link{presence_summary}}
}
