% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_DepMod.R
\name{run_model}
\alias{run_model}
\title{Run base and alternative simulation models}
\usage{
run_model(
  parameters = parameter_list,
  sim_runs = 1000,
  total_population = 10518000,
  df_prev_sub_base = data_prev_sub_base,
  df_tr_mild_base = data_tr_mild_base,
  df_tr_mod_base = data_tr_mod_base,
  df_tr_sev_base = data_tr_sev_base,
  df_prev_rec_base = data_prev_rec_base,
  df_prev_sub_alt = data_prev_sub_alt,
  df_tr_mild_alt = data_tr_mild_alt,
  df_tr_mod_alt = data_tr_mod_alt,
  df_tr_sev_alt = data_tr_sev_alt,
  df_prev_rec_alt = data_prev_rec_alt
)
}
\arguments{
\item{parameters}{Named list of model parameters (see Details).}

\item{sim_runs}{Integer. Number of simulation runs. Default is 1000.}

\item{total_population}{Integer. Total population size used in the simulation.
Default is 10518000.}

\item{df_prev_sub_base}{Data frame for base scenario prevention
(sub-clinical depression).}

\item{df_tr_mild_base}{Data frame for base scenario treatment (mild depression).}

\item{df_tr_mod_base}{Data frame for base scenario treatment
(moderate depression).}

\item{df_tr_sev_base}{Data frame for base scenario treatment
(severe depression).}

\item{df_prev_rec_base}{Data frame for base scenario prevention
(recurrent depression).}

\item{df_prev_sub_alt}{Data frame for alternative scenario prevention
(sub-clinical depression).}

\item{df_tr_mild_alt}{Data frame for alternative scenario treatment
(mild depression).}

\item{df_tr_mod_alt}{Data frame for alternative scenario treatment
(moderate depression).}

\item{df_tr_sev_alt}{Data frame for alternative scenario treatment
(severe depression).}

\item{df_prev_rec_alt}{Data frame for alternative scenario prevention
(recurrent depression).}
}
\value{
A list with two elements:
\describe{
\item{base}{Model output using the base scenario.}
\item{alt}{Model output using the alternative scenario.}
}

#' @examples
res <- run_model()
}
\description{
Wrapper for running the DepMod decision-analytic model under both base and
alternative scenarios. The function first builds the transition matrix using
\code{func_first_part_model()} and then runs \code{fun_sim_model()} for each
scenario.
}
\details{
The \code{parameters} list must contain numeric values controlling disease
progression, recovery, relapse, disability weights, discounting, and cost
accumulation. Required elements include:

\strong{General simulation parameters}
\describe{
\item{dw_conversion_fact}{Disability-weight conversion factor.}
\item{discount_rate_daly}{Discount rate for DALYs.}
\item{scale_shape_gamma_cost}{Gamma distribution scale/shape cost factor.}
\item{disc_rate_cost}{Discount rate for economic costs.}
\item{leavemodel}{Probability of leaving the model.}
\item{mean_dur_chron}{Mean duration of chronic phase.}
}

\strong{Population incidence inputs}
\describe{
\item{incidence_no_history}{Incidence among individuals without prior disease.}
\item{pmild}{Proportion of incident mild cases.}
\item{pmoderate}{Proportion of incident moderate cases.}
\item{psevere}{Proportion of incident severe cases.}
}

\strong{Stage-progression probabilities}
\describe{
\item{mildrecovery}{Recovery probability from mild depression.}
\item{mildpartial}{Partial remission probability (mild).}
\item{mildchronic}{Chronic transition probability (mild).}

\item{moderaterecovery}{Recovery probability (moderate).}
\item{moderatepartial}{Partial remission probability (moderate).}
\item{moderatechronic}{Chronic transition probability (moderate).}

\item{severerecovery}{Recovery probability (severe).}
\item{severepartial}{Partial remission probability (severe).}
\item{severechronic}{Chronic transition probability (severe).}
}

\strong{Recovery-state outcomes}
\describe{
\item{mildrecoverycured}{Cure probability from mild--recovery.}
\item{mildrecoveryrelapse}{Relapse probability from mild--recovery.}
\item{mildpartialcured}{Cure probability from mild--partial.}
\item{mildpartialrelapse}{Relapse probability from mild--partial.}

\item{moderaterecoverycured}{Cure probability from moderate--recovery.}
\item{moderaterecoveryrelapse}{Relapse probability from moderate--recovery.}
\item{moderatepartialcured}{Cure probability from moderate--partial.}
\item{moderatepartialrelapse}{Relapse probability from moderate--partial.}

\item{severerecoverycured}{Cure probability from severe--recovery.}
\item{severerecoveryrelapse}{Relapse probability from severe--recovery.}
\item{severepartialcured}{Cure probability from severe--partial.}
\item{severepartialrelapse}{Relapse probability from severe--partial.}
}

\strong{Relapse multipliers}
\describe{
\item{increased_relapse_1}{Relapse multiplier (category 1).}
\item{increased_relapse_2}{Relapse multiplier (category 2).}
\item{increased_relapse_3}{Relapse multiplier (category 3).}
\item{increased_relapse_4}{Relapse multiplier (category 4).}
\item{increased_relapse_5}{Relapse multiplier (category 5).}
}
}
