% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/view_excerpts.R
\name{view_excerpts}
\alias{view_excerpts}
\title{View Qualitative Excerpts by Code}
\usage{
view_excerpts(data)
}
\arguments{
\item{data}{A data frame containing at least one text column named \code{excerpt} and
one or more logical code columns prefixed with \code{"c_"}. Each logical column
represents whether a code was applied (\code{TRUE}/\code{FALSE}).}
}
\value{
A \code{\link[DT:datatable]{DT::datatable()}} object that displays:
\itemize{
\item \strong{Code:} readable code label or variable name
\item \strong{Excerpt:} associated qualitative text
}

The output table includes:
\itemize{
\item A dropdown filter for selecting specific codes
\item Search boxes for column-wise filtering
\item Responsive column widths and formatted text wrapping
}
}
\description{
Displays qualitative excerpts interactively in a searchable, filterable data table.
Each row represents an excerpt associated with one or more qualitative codes.
Code columns are automatically detected as those starting with \code{"c_"}, and their
variable labels (if available) are used as readable code names.

This function is primarily designed for exploring and reviewing coded qualitative data,
allowing users to filter by code and quickly browse the corresponding excerpts.
}
\details{
\itemize{
\item Variable labels are extracted from the \code{"label"} attribute of each code column
(e.g., assigned via \code{haven::labelled} or \code{attr(x, "label") <- "Label"}).
\item Only excerpts where a code is marked as \code{TRUE} are displayed.
\item The table uses custom styling with a purple header and automatic text wrapping.
}
}
\examples{
library(dplyr)

df <- tibble::tibble(
  excerpt = c(
    "I felt supported by my peers.",
    "Teachers really listened to us.",
    "I learned a lot about myself."
  ),
  c_support = c(TRUE, TRUE, FALSE),
  c_growth = c(FALSE, FALSE, TRUE)
)
attr(df$c_support, "label") <- "Peer/Teacher Support"
attr(df$c_growth, "label") <- "Personal Growth"

# View excerpts interactively
if (interactive()) view_excerpts(df)

}
