# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' helper function to unlist IDs generated by dbscan::frNN
#'
#'
#' creates a vector of indices from a nested list created by dbscan::frNN
#'
#' @param list a list element created by dbscan::frNN
#' @param l the expected length of the result
#' @return Returns a vector with the values in the list.
#' @author Julian Frey <julian.frey@@iww.uni-freiburg.de>
#' @export fast_unlist
fast_unlist <- function(list, l) {
    .Call(`_CspStandSegmentation_fast_unlist`, list, l)
}

#' helper function to unlist distances computed by dbscan::frNN
#'
#' extracts the distances from a nested list created by dbscan::frNN
#'
#' @param list a list element created by dbscan::frNN
#' @param l the expected length of the result
#' @return Returns a vector with the values in the list.
#' @author Julian Frey <julian.frey@@iww.uni-freiburg.de>
#' @export fast_unlist_dist
fast_unlist_dist <- function(list, l) {
    .Call(`_CspStandSegmentation_fast_unlist_dist`, list, l)
}

#' Fast Eigenvalues decomposition for k nearest neighbors using a C++ function
#'
#' C++ helper function to compute eigenvalues for geometric feature
#' calculation.
#'
#' @param las LAS element
#' @param k k nearest neighbors
#' @param ncpu number of cpu cores to use
#' @return The function returns for every point the 3 eigenvalues and the
#' third element of the third eigenvector. These values are needed to compute
#' planarity, linerity, verticality etc. in the add_geometry function
#' @author Julian Frey <julian.frey@@iww.uni-freiburg.de>
#' @seealso \link{add_geometry}
#' @export eigen_decomposition
eigen_decomposition <- function(las, k, ncpu = 1L) {
    .Call(`_CspStandSegmentation_eigen_decomposition`, las, k, ncpu)
}

