% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Empirical_est.R
\name{humc_dynamic}
\alias{humc_dynamic}
\title{R function that calculates empirical estimates of HUMcm}
\usage{
humc_dynamic(dat, num_sub)
}
\arguments{
\item{dat}{test values in list, each element represents biomarker values for a disease group, ordered in ascending severity}

\item{num_sub}{a vector of number of subclasses in each subclass}
}
\value{
The empirical estimate of HUMcm based on given data and num_sub
}
\description{
This function provides empirical estimates of HUMcm
}
\examples{
# Create a list of example data
Y1 <- c(0.9316, 0.9670, 1.3856, 1.3505, 1.0316, 1.1764, 0.7435, 0.5813, 0.4695, 0.3249)
Y2 <- c(1.63950, 1.36535, 1.79859, 0.47961, 1.50978, 1.36525,0.13515, 2.11275, 0.45659)
Y3 <- c(1.89856, 1.30920, 2.38615, 2.34785, 2.92493, 2.71615, 2.75243, 0.95060, 0.38964)
Y4 <- c(2.580,2.570,2.143,3.079,1.765,3.081,2.175,2.306,2.918,2.507,4.261,3.033,1.836,2.321)
Y5 <- c(3.969,3.044,3.318,2.862,3.655,1.523,3.722,4.074,3.662,3.571,5.177,6.321,4.932,4.129)
Y.dat <- list(Y1,Y2,Y3,Y4,Y5)
num_sub <- c(1,3,1)
# calculate HUMcm of Y.dat and num_sub
humc_dynamic(Y.dat,num_sub)
}
