% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/benchmarkCohortCharacteristics.R
\name{benchmarkCohortCharacteristics}
\alias{benchmarkCohortCharacteristics}
\title{Benchmark the main functions of CohortCharacteristics package.}
\usage{
benchmarkCohortCharacteristics(
  cohort,
  analysis = c("count", "attrition", "characteristics", "overlap", "timing",
    "large scale characteristics")
)
}
\arguments{
\item{cohort}{A cohort_table from a cdm_reference.}

\item{analysis}{Set of analysis to perform, must be a subset of: "count",
"attrition", "characteristics", "overlap", "timing" and
"large scale characteristics".}
}
\value{
A summarised_result object.
}
\description{
Benchmark the main functions of CohortCharacteristics package.
}
\examples{
\dontrun{
library(CohortCharacteristics)
library(omock)
library(CDMConnector)

cdm <- mockCdmFromDataset(datasetName = "GiBleed", source = "duckdb")

cdm <- generateConceptCohortSet(
  cdm = cdm,
  conceptSet = list(sinusitis = 40481087, pharyngitis = 4112343),
  name = "my_cohort"
)

benchmarkCohortCharacteristics(cdm$my_cohort)

}
}
