#' Example Actigraphy Dataset
#'
#' A single-subject actigraphy dataset from the NHANES 2013–2014 study,
#' provided as an example for demonstrating the CircaCP workflow.
#'
#' @format A data frame with one row per recorded epoch and the following variables:
#' \describe{
#'   \item{Date}{Date of recording (synthetic or reconstructed from NHANES information).}
#'   \item{Time}{Time of day corresponding to each observation.}
#'   \item{Lux}{Light intensity.}
#'   \item{SDLux}{Short-term variability of light intensity.}
#'   \item{MIMS}{Activity magnitude calculated using the MIMS algorithm.}
#'   \item{X}{Raw or calibrated X-axis signal from the accelerometer.}
#'   \item{Y}{Raw or calibrated Y-axis signal from the accelerometer.}
#'   \item{Z}{Raw or calibrated Z-axis signal from the accelerometer.}
#' }
#' @source National Health and Nutrition Examination Survey (NHANES) 2013–2014.
#'
#' @examples
#' data(actigraphy)
#' head(actigraphy)
"actigraphy"
